/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.toolkit.constant;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0007J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\u001b\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00172\u0006\u0010\u0013\u001a\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcn/toutatis/xvoid/toolkit/constant/Regex;", "", "()V", "EMAIL_REGEX", "", "EN_USERNAME_REGEX", "IMAGE_SUFFIX_REGEX", "IPV4_ADDRESS_REGEX", "IPV6_ADDRESS_REGEX", "NUMBER_REGEX", "PASSWORD_REGEX_01", "PASSWORD_REGEX_02", "PASSWORD_REGEX_03", "PASSWORD_REGEX_04", "PUNCTUATION_REGEX", "REQUEST_JSESSION_ID_REGEX", "SIMPLE_USERNAME_REGEX", "TEL_REGEX", "convertSingleLine", "input", "parseAntToRegex", "antPattern", "splitAlphaNumeric", "", "(Ljava/lang/String;)[Ljava/lang/String;", "validateRegex", "", "regex", "void-toolkit"})
public final class Regex {
    @NotNull
    public static final Regex INSTANCE = new Regex();
    @NotNull
    public static final String TEL_REGEX = "^(1[3-9]\\d{9}$)";
    @NotNull
    public static final String EMAIL_REGEX = "^[a-zA-Z0-9_-]+@[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)+$";
    @NotNull
    public static final String PUNCTUATION_REGEX = "[\n`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c \u3001\uff1f]";
    @NotNull
    public static final String IPV4_ADDRESS_REGEX = "((2(5[0-5]|[0-4]\\d))|[0-1]?\\d{1,2})(\\.((2(5[0-5]|[0-4]\\d))|[0-1]?\\d{1,2})){3}";
    @NotNull
    public static final String IPV6_ADDRESS_REGEX = "([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){2,2}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|(([0-9a-fA-F]{1,4}:){1,4}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])";
    @NotNull
    public static final String SIMPLE_USERNAME_REGEX = "^[a-zA-Z0-9_\u4e00-\u9fa5]{2,32}$";
    @NotNull
    public static final String EN_USERNAME_REGEX = "^[a-zA-Z0-9_]{2,32}$";
    @NotNull
    public static final String NUMBER_REGEX = "-?[0-9]+(\\.[0-9]+)?";
    @NotNull
    public static final String IMAGE_SUFFIX_REGEX = "png|jpg|jpeg";
    @NotNull
    public static final String REQUEST_JSESSION_ID_REGEX = "JSESSIONID=([a-fA-F0-9]+);";
    @NotNull
    public static final String PASSWORD_REGEX_01 = "^(?=.*[A-Z])(?=.*[a-z])(?=.*\\d).{8,32}$";
    @NotNull
    public static final String PASSWORD_REGEX_02 = "^(?!.*\\s)[A-Za-z\\d@#$%^&+=]{8,32}$";
    @NotNull
    public static final String PASSWORD_REGEX_03 = "^[A-Za-z0-9!@#\\\\$%\\\\^&*()-_+=<>?]{8,32}$";
    @NotNull
    public static final String PASSWORD_REGEX_04 = "^(?=.*[A-Za-z])[A-Za-z0-9!@#\\\\$%\\\\^&*()-_+=<>?]{8,32}$";

    private Regex() {
    }

    private final String parseAntToRegex(String antPattern) {
        String regex = antPattern;
        regex = StringsKt.replace$default((String)regex, (String)"*", (String)".*", (boolean)false, (int)4, null);
        regex = StringsKt.replace$default((String)regex, (String)"?", (String)".", (boolean)false, (int)4, null);
        regex = StringsKt.replace$default((String)regex, (String)"**", (String)".*", (boolean)false, (int)4, null);
        regex = StringsKt.replace$default((String)regex, (String)"{", (String)"(", (boolean)false, (int)4, null);
        regex = StringsKt.replace$default((String)regex, (String)"}", (String)")", (boolean)false, (int)4, null);
        regex = StringsKt.replace$default((String)regex, (String)"[", (String)"[", (boolean)false, (int)4, null);
        regex = StringsKt.replace$default((String)regex, (String)"]", (String)"]", (boolean)false, (int)4, null);
        regex = StringsKt.replace$default((String)regex, (String)"!", (String)"^", (boolean)false, (int)4, null);
        return regex;
    }

    @JvmStatic
    @NotNull
    public static final String[] splitAlphaNumeric(@NotNull String input) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Pattern pattern = Pattern.compile("([a-zA-Z]+)(\\d+)");
        Matcher matcher = pattern.matcher(input);
        Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
        Matcher matcher2 = matcher;
        if (matcher2.matches()) {
            String string = matcher2.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            String alphaPart = string;
            String string2 = matcher2.group(2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
            String numericPart = string2;
            String[] stringArray2 = new String[]{alphaPart, numericPart};
            stringArray = stringArray2;
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    @JvmStatic
    @NotNull
    public static final String convertSingleLine(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        CharSequence charSequence = input;
        kotlin.text.Regex regex = new kotlin.text.Regex("\\s");
        String string = "";
        return regex.replace(charSequence, string);
    }

    public final boolean validateRegex(@Nullable String regex) {
        boolean bl;
        if (regex == null) {
            return false;
        }
        try {
            Pattern.compile(regex);
            bl = true;
        }
        catch (PatternSyntaxException e) {
            bl = false;
        }
        return bl;
    }
}

