/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.toolkit.formatting;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u0004H\u0007\u00a8\u0006\t"}, d2={"Lcn/toutatis/xvoid/toolkit/formatting/XmlToolkit;", "", "()V", "mapToXml", "", "data", "Lcom/alibaba/fastjson/JSONObject;", "xmlToMap", "xml", "void-toolkit"})
public final class XmlToolkit {
    @NotNull
    public static final XmlToolkit INSTANCE = new XmlToolkit();

    private XmlToolkit() {
    }

    @JvmStatic
    @Nullable
    public static final JSONObject xmlToMap(@NotNull String xml) {
        JSONObject jSONObject;
        Intrinsics.checkNotNullParameter((Object)xml, (String)"xml");
        try {
            JSONObject data = new JSONObject(true);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            String string = xml;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            InputStream stream = new ByteArrayInputStream(byArray);
            Document doc = documentBuilder.parse(stream);
            doc.getDocumentElement().normalize();
            NodeList nodeList = doc.getDocumentElement().getChildNodes();
            int n = nodeList.getLength();
            for (int idx = 0; idx < n; ++idx) {
                Node node = nodeList.item(idx);
                if (node.getNodeType() != 1) continue;
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
                Element element = (Element)node;
                ((Map)data).put(element.getNodeName(), element.getTextContent());
            }
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            jSONObject = null;
        }
        return jSONObject;
    }

    @JvmStatic
    @Nullable
    public static final String mapToXml(@NotNull JSONObject data) {
        String string;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element root = document.createElement("xml");
            document.appendChild(root);
            for (String key : data.keySet()) {
                Node node;
                Text text;
                Object value = data.get((Object)key);
                Element filed = document.createElement(key);
                Object object = value;
                if (Intrinsics.areEqual(object != null ? object.getClass() : null, String.class)) {
                    text = document.createCDATASection(value.toString());
                    Intrinsics.checkNotNull((Object)text);
                    node = text;
                } else {
                    text = document.createTextNode(String.valueOf(value));
                    Intrinsics.checkNotNull((Object)text);
                    node = text;
                }
                Node node2 = node;
                filed.appendChild(node2);
                root.appendChild(filed);
            }
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            DOMSource source = new DOMSource(document);
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
            String string2 = writer.getBuffer().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String output = string2;
            writer.close();
            string = output;
        }
        catch (Exception e) {
            e.printStackTrace();
            string = null;
        }
        return string;
    }
}

