/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.toolkit.validator;

import cn.toutatis.xvoid.achievable.filter.AbstractWordSearchFilter;
import cn.toutatis.xvoid.achievable.filter.WordSearchResult;
import cn.toutatis.xvoid.structure.tree.TrieNode;
import cn.toutatis.xvoid.toolkit.validator.Validator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\n\"\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0016R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcn/toutatis/xvoid/toolkit/validator/SensitiveWordFilter;", "Lcn/toutatis/xvoid/achievable/filter/AbstractWordSearchFilter;", "()V", "excludeWords", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "exclude", "", "words", "", "([Ljava/lang/String;)V", "search", "", "Lcn/toutatis/xvoid/achievable/filter/WordSearchResult;", "text", "void-toolkit"})
@SourceDebugExtension(value={"SMAP\nSensitiveWordFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SensitiveWordFilter.kt\ncn/toutatis/xvoid/toolkit/validator/SensitiveWordFilter\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,71:1\n215#2,2:72\n13309#3,2:74\n*S KotlinDebug\n*F\n+ 1 SensitiveWordFilter.kt\ncn/toutatis/xvoid/toolkit/validator/SensitiveWordFilter\n*L\n52#1:72,2\n65#1:74,2\n*E\n"})
public final class SensitiveWordFilter
extends AbstractWordSearchFilter {
    @NotNull
    private final HashSet<String> excludeWords = new HashSet();

    @NotNull
    public List<WordSearchResult> search(@Nullable String text) {
        List filteredWords = new ArrayList();
        if (Validator.strIsBlank(text)) {
            return filteredWords;
        }
        StringBuilder currentWord = new StringBuilder();
        TrieNode trieNode = this.root;
        Intrinsics.checkNotNullExpressionValue((Object)trieNode, (String)"root");
        TrieNode current = trieNode;
        int idx = 0;
        LinkedHashMap records = new LinkedHashMap();
        while (true) {
            String string = text;
            Intrinsics.checkNotNull((Object)string);
            char[] cArray = string.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            if (idx >= cArray.length) break;
            char currentCharacter = text.charAt(idx);
            boolean treeExist = current.childrenNodes().containsKey(Character.valueOf(currentCharacter));
            if (treeExist) {
                Object v = current.childrenNodes().get(Character.valueOf(currentCharacter));
                Intrinsics.checkNotNull(v);
                current = (TrieNode)v;
                currentWord.append(currentCharacter);
                if (current.isEndNode()) {
                    String word;
                    Intrinsics.checkNotNullExpressionValue((Object)currentWord.toString(), (String)"toString(...)");
                    ArrayList positionList = null;
                    if (!records.containsKey(word)) {
                        positionList = new ArrayList();
                        ((Map)records).put(word, positionList);
                    } else {
                        Object v2 = records.get(word);
                        Intrinsics.checkNotNull(v2);
                        positionList = (ArrayList)v2;
                    }
                    int i = idx - word.length();
                    if (i <= 0) {
                        i = 0;
                    }
                    positionList.add(i);
                }
            } else {
                if (((CharSequence)currentWord).length() > 0) {
                    --idx;
                }
                currentWord = new StringBuilder();
                Intrinsics.checkNotNullExpressionValue((Object)this.root, (String)"root");
            }
            ++idx;
        }
        Map $this$forEach$iv = records;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String word = (String)entry.getKey();
            ArrayList positionList = (ArrayList)entry.getValue();
            SensitiveWordFilter $this$search_u24lambda_u241_u24lambda_u240 = this;
            boolean bl2 = false;
            if ($this$search_u24lambda_u241_u24lambda_u240.excludeWords.contains(word)) continue;
            filteredWords.add(new WordSearchResult((List)positionList, word));
        }
        return filteredWords;
    }

    public final void exclude(String ... words) {
        Intrinsics.checkNotNullParameter((Object)words, (String)"words");
        String[] $this$forEach$iv = words;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (Validator.strIsBlank(it)) continue;
            this.excludeWords.add(it);
        }
    }
}

