/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.toolkit.http;

import cn.toutatis.xvoid.common.exception.base.UnSettledException;
import cn.toutatis.xvoid.common.exception.base.VoidIOException;
import cn.toutatis.xvoid.common.exception.base.VoidRuntimeException;
import cn.toutatis.xvoid.common.exception.parameter.WrongParameterException;
import cn.toutatis.xvoid.toolkit.log.LoggerToolkit;
import cn.toutatis.xvoid.toolkit.log.LoggerToolkitKt;
import java.io.Closeable;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0002J@\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0016\b\u0002\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0002J&\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0007J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\t\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\t\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002JL\u0010\u001b\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\r2\u0016\b\u0002\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0007J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\rH\u0007J(\u0010\u001d\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\r2\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0007JB\u0010\u001d\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\r2\u0016\b\u0002\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0007JJ\u0010\u001d\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\r2\u0016\b\u0002\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0007JJ\u0010\u001e\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0010\u001a\u00020\r2\u0016\b\u0002\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\rH\u0007J*\u0010\u001f\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\r2\u0016\b\u0002\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0007J>\u0010\u001f\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\r2\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0007JL\u0010\u001f\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\r2\u0016\b\u0002\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcn/toutatis/xvoid/toolkit/http/HttpToolkit;", "", "()V", "httpClient", "Lokhttp3/OkHttpClient;", "logger", "Lorg/slf4j/Logger;", "addHeader", "", "request", "Lokhttp3/Request$Builder;", "headers", "", "", "buildSimpleRequest", "Lokhttp3/Request;", "url", "params", "concatMapParameters", "queries", "getResponse", "Lokhttp3/Response;", "throwException", "", "getResponseBodyAsBytes", "", "getResponseBodyAsString", "post", "formBody", "syncGet", "syncGetAsBytes", "syncGetAsResponse", "void-toolkit"})
@SourceDebugExtension(value={"SMAP\nHttpToolkit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpToolkit.kt\ncn/toutatis/xvoid/toolkit/http/HttpToolkit\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,231:1\n1#2:232\n215#3,2:233\n*S KotlinDebug\n*F\n+ 1 HttpToolkit.kt\ncn/toutatis/xvoid/toolkit/http/HttpToolkit\n*L\n228#1:233,2\n*E\n"})
public final class HttpToolkit {
    @NotNull
    public static final HttpToolkit INSTANCE = new HttpToolkit();
    @NotNull
    private static final Logger logger = LoggerToolkit.getLogger(HttpToolkit.class);
    @NotNull
    private static OkHttpClient httpClient = new OkHttpClient();

    private HttpToolkit() {
    }

    @JvmStatic
    @Nullable
    public static final String syncGet(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return HttpToolkit.syncGet(url, null, null, false);
    }

    @JvmStatic
    @Nullable
    public static final String syncGet(@NotNull String url, @Nullable Map<String, String> params) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return HttpToolkit.syncGet(url, params, null, false);
    }

    @JvmStatic
    @Nullable
    public static final String syncGet(@NotNull String url, @Nullable Map<String, String> params, @Nullable Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return HttpToolkit.syncGet(url, params, headers, false);
    }

    public static /* synthetic */ String syncGet$default(String string, Map map, Map map2, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        if ((n & 4) != 0) {
            map2 = null;
        }
        return HttpToolkit.syncGet(string, map, map2);
    }

    @JvmStatic
    @Nullable
    public static final String syncGet(@NotNull String url, @Nullable Map<String, String> params, @Nullable Map<String, String> headers, boolean throwException) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return INSTANCE.getResponseBodyAsString(INSTANCE.buildSimpleRequest(url, params, headers), throwException);
    }

    public static /* synthetic */ String syncGet$default(String string, Map map, Map map2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        if ((n & 4) != 0) {
            map2 = null;
        }
        return HttpToolkit.syncGet(string, map, map2, bl);
    }

    @JvmStatic
    @Nullable
    public static final byte[] syncGetAsBytes(@NotNull String url, @Nullable Map<String, String> params, @Nullable Map<String, String> headers, boolean throwException) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return INSTANCE.getResponseBodyAsBytes(INSTANCE.buildSimpleRequest(url, params, headers), throwException);
    }

    public static /* synthetic */ byte[] syncGetAsBytes$default(String string, Map map, Map map2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        if ((n & 4) != 0) {
            map2 = null;
        }
        return HttpToolkit.syncGetAsBytes(string, map, map2, bl);
    }

    @JvmStatic
    @Nullable
    public static final Response syncGetAsResponse(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return HttpToolkit.getResponse(INSTANCE.buildSimpleRequest(url, null, null), false);
    }

    @JvmStatic
    @Nullable
    public static final Response syncGetAsResponse(@NotNull String url, @Nullable Map<String, String> params) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return HttpToolkit.getResponse(INSTANCE.buildSimpleRequest(url, params, null), false);
    }

    public static /* synthetic */ Response syncGetAsResponse$default(String string, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        return HttpToolkit.syncGetAsResponse(string, map);
    }

    @JvmStatic
    @Nullable
    public static final Response syncGetAsResponse(@NotNull String url, @Nullable Map<String, String> params, @Nullable Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return HttpToolkit.getResponse(INSTANCE.buildSimpleRequest(url, params, headers), false);
    }

    @JvmStatic
    @Nullable
    public static final Response syncGetAsResponse(@NotNull String url, @Nullable Map<String, String> params, @Nullable Map<String, String> headers, boolean throwException) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return HttpToolkit.getResponse(INSTANCE.buildSimpleRequest(url, params, headers), throwException);
    }

    public static /* synthetic */ Response syncGetAsResponse$default(String string, Map map, Map map2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        if ((n & 4) != 0) {
            map2 = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return HttpToolkit.syncGetAsResponse(string, map, map2, bl);
    }

    private final Request buildSimpleRequest(String url, Map<String, String> params, Map<String, String> headers) {
        Request.Builder builder = new Request.Builder();
        String urlWithParams = HttpToolkit.concatMapParameters(url, params);
        builder.url(urlWithParams);
        this.addHeader(builder, headers);
        return builder.build();
    }

    static /* synthetic */ Request buildSimpleRequest$default(HttpToolkit httpToolkit, String string, Map map, Map map2, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        if ((n & 4) != 0) {
            map2 = null;
        }
        return httpToolkit.buildSimpleRequest(string, map, map2);
    }

    @JvmStatic
    @Nullable
    public static final String post(@NotNull String url, @Nullable Map<String, String> formBody, @Nullable Map<String, String> headers, boolean throwException) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        FormBody.Builder builder = new FormBody.Builder(null, 1, null);
        Map<String, String> map = formBody;
        if (!(map == null || map.isEmpty())) {
            for (String key : formBody.keySet()) {
                if (formBody.get(key) != null) {
                    String it;
                    boolean bl = false;
                    builder.add(key, it);
                }
            }
        }
        Request.Builder requestBuilder = new Request.Builder();
        INSTANCE.addHeader(requestBuilder, headers);
        Request request = requestBuilder.url(url).post((RequestBody)builder.build()).build();
        return INSTANCE.getResponseBodyAsString(request, throwException);
    }

    public static /* synthetic */ String post$default(String string, Map map, Map map2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        if ((n & 4) != 0) {
            map2 = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return HttpToolkit.post(string, map, map2, bl);
    }

    @JvmStatic
    @NotNull
    public static final String concatMapParameters(@NotNull String url, @Nullable Map<String, String> queries) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        StringBuilder urlBuilder = new StringBuilder(url);
        Map<String, String> map = queries;
        if (!(map == null || map.isEmpty())) {
            boolean firstParameterFlag = true;
            for (Map.Entry<String, String> entry : queries.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (firstParameterFlag) {
                    urlBuilder.append('?' + key + '=' + value);
                    firstParameterFlag = false;
                    continue;
                }
                urlBuilder.append('&' + key + '=' + value);
            }
        }
        String string = urlBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmStatic
    @Nullable
    public static final Response getResponse(@NotNull Request request, boolean throwException) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            return httpClient.newCall(request).execute();
        }
        catch (Exception e) {
            LoggerToolkitKt.warnWithModule(logger, "XVOID-TOOLKIT", "\u8bf7\u6c42\u5931\u8d25[URL:" + request.url() + ']');
            if (!throwException) {
                return null;
            }
            VoidRuntimeException exception = null;
            String errorMessage = e.getMessage();
            String returnMessage = e.getMessage();
            KClass kClass = Reflection.getOrCreateKotlinClass(e.getClass());
            if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(UnknownHostException.class))) {
                exception = (VoidRuntimeException)new VoidIOException("\u8bf7\u6c42\u5730\u5740[" + request.url() + "]\u65e0\u6cd5\u89e3\u6790");
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(IOException.class))) {
                exception = (VoidRuntimeException)new VoidIOException(e.getMessage());
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(IllegalArgumentException.class)) && errorMessage != null && StringsKt.contains$default((CharSequence)errorMessage, (CharSequence)"Invalid URL host", (boolean)false, (int)2, null)) {
                returnMessage = "\u9519\u8bef\u7684\u8bf7\u6c42\u5730\u5740[" + request.url() + ']';
                exception = (VoidRuntimeException)new WrongParameterException(returnMessage);
            }
            if (exception == null) {
                e.printStackTrace();
                LoggerToolkitKt.errorWithModule(logger, "XVOID-TOOLKIT", "\u672a\u5904\u7406\u7684\u9519\u8bef\u539f\u56e0:[" + returnMessage + ']');
                exception = (VoidRuntimeException)new UnSettledException();
            } else {
                LoggerToolkitKt.errorWithModule(logger, "XVOID-TOOLKIT", "\u9519\u8bef\u539f\u56e0:[" + returnMessage + ']');
            }
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getResponseBodyAsString(Request request, boolean throwException) {
        String message = null;
        Response response = HttpToolkit.getResponse(request, throwException);
        if (response == null) {
            if (throwException) {
                throw new VoidIOException("\u83b7\u53d6\u54cd\u5e94\u4f53\u5931\u8d25,\u8bf7\u67e5\u8be2\u539f\u56e0[URL:" + request.url() + ']');
            }
            return null;
        }
        Closeable closeable = (Closeable)response;
        Throwable throwable = null;
        try {
            Response it = (Response)closeable;
            boolean bl = false;
            message = response.body().string();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] getResponseBodyAsBytes(Request request, boolean throwException) {
        byte[] message = null;
        Response response = HttpToolkit.getResponse(request, throwException);
        if (response == null) {
            if (throwException) {
                throw new VoidIOException("\u83b7\u53d6\u54cd\u5e94\u4f53\u5931\u8d25,\u8bf7\u67e5\u8be2\u539f\u56e0[URL:" + request.url() + ']');
            }
            return null;
        }
        Closeable closeable = (Closeable)response;
        Throwable throwable = null;
        try {
            Response it = (Response)closeable;
            boolean bl = false;
            message = response.body().bytes();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return message;
    }

    private final void addHeader(Request.Builder request, Map<String, String> headers) {
        block1: {
            Map<String, String> map = headers;
            if (map == null) break block1;
            Map<String, String> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> entry = element$iv = iterator.next();
                boolean bl = false;
                String k = entry.getKey();
                String v = entry.getValue();
                request.addHeader(k, v);
            }
        }
    }
}

