package cn.tworice.auth.service.impl;

import cn.tworice.auth.service.AuthConst;
import cn.tworice.auth.service.AuthManager;

import cn.tworice.common.vo.RequestResult;
import cn.tworice.common.vo.StateCodeConst;
import com.alibaba.fastjson.JSON;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;

/**
 * 验证Token是否有效
 * @author 二饭 [2022/11/6]
 **/
@Service
@Slf4j
public class DefaultAuthManager implements AuthManager {

    @Override
    public boolean auth(HttpServletRequest request, HttpServletResponse response) {
        try {
            String token = request.getHeader(AuthConst.ACCESS_TOKEN);
            String adminID = request.getHeader(AuthConst.ADMIN_ID);

            // token必须传递
//            if (token == null || !onlineService.exist(adminID,token)) {
//                returnJson(response, "请求未授权");
//                return false;
//            }
            // 解码
            DecodedJWT decode = JWT.decode(token);
            // 验证密钥是否正确
            this.verifyKey(adminID, decode);
            // 有效期是否超时
            if (!this.verifyTimeOut(decode)) {
                this.returnJson(response, "Token未授权或已超时");
            }
            return true;
        }catch (Exception ex){
            this.returnJson(response, "Token未授权或已超时");
        }
        return false;
    }

    /**
     * 验证有效期
     * @author 二饭 [2022/9/28]
     **/
    private boolean verifyTimeOut(DecodedJWT decode) {
        Date expiresAt = decode.getExpiresAt();
        return !(expiresAt.getTime() < System.currentTimeMillis());
    }

    /**
     * 验证密钥是否正确
     * @author 二饭 [2022/9/28]
     **/
    private void verifyKey(String adminID,DecodedJWT decode) {
        Algorithm algorithm = Algorithm.HMAC256(adminID);
        algorithm.verify(decode);
    }

    /**
     * 请求被拦截后返回给客户端数据
     * @author 二饭
     */
    private void returnJson(HttpServletResponse response,String message){
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html; charset=utf-8");
        RequestResult result = new RequestResult(StateCodeConst.LOGIN_ERROR,message);
        try (PrintWriter writer = response.getWriter()){
            writer.print(JSON.toJSONString(result));
        } catch (IOException e) {
            log.error(e.getMessage());
        }
    }
}
