package cn.tworice.auth.config;


import cn.tworice.auth.interceptor.AuthInterceptor;
import cn.tworice.auth.interceptor.SQLInjectionInterceptor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import javax.annotation.Resource;
import java.io.File;

@Configuration
public class InterceptorConfig implements WebMvcConfigurer {

    @Resource
    private AuthProperties authProperties;

    @Bean
    public AuthInterceptor adminInterceptor(){
        return new AuthInterceptor();
    }

    @Bean
    public SQLInjectionInterceptor sqlInjectionInterceptor(){
        return new SQLInjectionInterceptor();
    }

    /**
     * 注册拦截器
     */
    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(adminInterceptor())
                .addPathPatterns(authProperties.getInterceptPaths())   // 拦截请求
                .excludePathPatterns(authProperties.getExcludePaths());    // 放行请求
        if(authProperties.getSqlInjection()){
            registry.addInterceptor(sqlInjectionInterceptor())
                    .addPathPatterns("/**");   // 拦截请求
        }
    }
}
