/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.auth.service.impl;

import cn.tworice.auth.service.AuthManager;
import cn.tworice.common.vo.RequestResult;
import cn.tworice.common.vo.StateCodeConst;
import com.alibaba.fastjson.JSON;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DefaultAuthManager
implements AuthManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultAuthManager.class);

    @Override
    public boolean auth(HttpServletRequest request, HttpServletResponse response) {
        try {
            String token = request.getHeader("token");
            String adminID = request.getHeader("adminID");
            DecodedJWT decode = JWT.decode((String)token);
            this.verifyKey(adminID, decode);
            if (!this.verifyTimeOut(decode)) {
                this.returnJson(response, "Token\u672a\u6388\u6743\u6216\u5df2\u8d85\u65f6");
            }
            return true;
        }
        catch (Exception ex) {
            this.returnJson(response, "Token\u672a\u6388\u6743\u6216\u5df2\u8d85\u65f6");
            return false;
        }
    }

    private boolean verifyTimeOut(DecodedJWT decode) {
        Date expiresAt = decode.getExpiresAt();
        return expiresAt.getTime() >= System.currentTimeMillis();
    }

    private void verifyKey(String adminID, DecodedJWT decode) {
        Algorithm algorithm = Algorithm.HMAC256((String)adminID);
        algorithm.verify(decode);
    }

    private void returnJson(HttpServletResponse response, String message) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html; charset=utf-8");
        RequestResult result = new RequestResult(StateCodeConst.LOGIN_ERROR.intValue(), message);
        try (PrintWriter writer = response.getWriter();){
            writer.print(JSON.toJSONString((Object)result));
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
    }
}

