/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.auth.config;

import cn.tworice.auth.config.AuthProperties;
import cn.tworice.auth.interceptor.AuthInterceptor;
import cn.tworice.auth.interceptor.SQLInjectionInterceptor;
import javax.annotation.Resource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class InterceptorConfig
implements WebMvcConfigurer {
    @Resource
    private AuthProperties authProperties;

    @Bean
    public AuthInterceptor adminInterceptor() {
        return new AuthInterceptor();
    }

    @Bean
    public SQLInjectionInterceptor sqlInjectionInterceptor() {
        return new SQLInjectionInterceptor();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.adminInterceptor()).addPathPatterns(this.authProperties.getInterceptPaths()).excludePathPatterns(this.authProperties.getExcludePaths());
        if (this.authProperties.getSqlInjection().booleanValue()) {
            registry.addInterceptor((HandlerInterceptor)this.sqlInjectionInterceptor()).addPathPatterns(new String[]{"/**"});
        }
    }
}

