/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.auth.service.impl;

import cn.tworice.auth.service.SQLInjectionService;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;

@Service
public class DefaultSQLInjectionServiceImpl
implements SQLInjectionService {
    private static final Pattern SQL_INJECTION_PATTERN = Pattern.compile("(?:\\b(?:select|update|delete|insert|truncate|alter|drop|create|exec|execute|declare|union|merge|call)\\b|\\b(?:--|;|'|\"|\\/\\*|\\*\\/|\\\\x|--|\\/\\*|\\*\\/|\\\\x).*)", 42);

    @Override
    public boolean isSQLInjection(HttpServletRequest request) {
        String requestPath = request.getRequestURI();
        if (SQL_INJECTION_PATTERN.matcher(requestPath).find()) {
            return true;
        }
        Iterator iterator = request.getParameterMap().values().iterator();
        while (iterator.hasNext()) {
            String[] paramValues;
            for (String paramValue : paramValues = (String[])iterator.next()) {
                if (paramValue == null || !SQL_INJECTION_PATTERN.matcher(paramValue).find()) continue;
                return true;
            }
        }
        return false;
    }
}

