package cn.tworice.auth.config;

import lombok.Data;
import org.springframework.stereotype.Component;
import org.springframework.boot.context.properties.ConfigurationProperties;


@Data
@Component
@ConfigurationProperties(prefix = "tworice.auth")
public class AuthProperties {
    private Boolean sqlInjection = false;
    private Boolean blast = true; // 防爆破开关
    private Integer blastCount = 5;
    private String[] interceptPaths = {"/admin/**", "/client/**"};
    private String[] excludePaths = {"/admin/login/**", "/editor/**", "/admin/admin/template", "/admin/system/offline", "/admin/cryption", "/admin/cryption/**"};
    private String mailBlast;

    public void setMailBlast(String mailBlast) {
        this.mailBlast = mailBlast;
    }
}
