/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.auth.interceptor;

import cn.tworice.auth.service.SQLInjectionService;
import cn.tworice.common.vo.RequestResult;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.PrintWriter;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.servlet.HandlerInterceptor;

public class SQLInjectionInterceptor
implements HandlerInterceptor {
    @Resource
    private SQLInjectionService sqlInjectionService;
    @Value(value="${tworice.auth.sqlInjection:true}")
    private Boolean sqlInjection;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        if (!this.sqlInjection.booleanValue()) {
            return true;
        }
        String origin = request.getHeader("Origin");
        if (origin != null) {
            response.setHeader("Access-Control-Allow-Origin", "*");
            response.setHeader("Access-Control-Allow-Methods", "POST, GET, OPTIONS, DELETE, PUT, HEAD");
            response.setHeader("Access-Control-Allow-Headers", "Content-Type, Token, adminID");
            response.setHeader("Access-Control-Max-Age", "3600");
        }
        if (this.sqlInjectionService.isSQLInjection(request)) {
            this.returnJson(response, "\u60a8\u7684\u8bf7\u6c42\u5305\u542bSQL\u6ce8\u5165");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnJson(HttpServletResponse response, String message) {
        PrintWriter writer = null;
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html; charset=utf-8");
        String jsonString = JSON.toJSONString((Object)RequestResult.error((Integer)401, (String)message));
        try {
            writer = response.getWriter();
            writer.print(jsonString);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }
}

