package cn.tworice.auth.config;

import lombok.Data;
import lombok.Setter;
import org.springframework.stereotype.Component;
import org.springframework.boot.context.properties.ConfigurationProperties;


@Data
@Component
@ConfigurationProperties(prefix = "tworice.auth")
public class AuthProperties {
    private Boolean sqlInjection = false;
    private Boolean blast = true; // 防爆破开关
    private Integer blastCount = 5;
    private String[] interceptPaths = {"/admin/**", "/client/**"};
    private String[] excludePaths = {"/admin/login/**", "/editor/**", "/admin/admin/template", "/admin/system/offline", "/admin/cryption", "/admin/cryption/**"};
    @Setter
    private String mailBlast;
    /**
     * Token有效期低于这个数值后自动刷新Token有效期
     */
    private Long refreshTime = 12 * 60 * 60 * 1000L;
}
