package cn.tworice.auth.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;

import java.util.Date;

/**
 * Token生成工具
 * @author 二饭 [2022/9/19]
 **/
public class TokenUtils {

    /**
     * 传入管理员对象，生成该管理员对象的24小时时效的Token
     *
     * @param uid 用户标识
     * @return java.lang.String token串
     **/
    public static String getAdminToken(String uid, Long timeout) {
        long time = System.currentTimeMillis() + timeout;
        Date date = new Date();
        date.setTime(time);
        return JWT.create()
                .withAudience(uid) // 将用户ID存入token中
                .withExpiresAt(date)    // 设置过期时间
                .sign(Algorithm.HMAC256(uid));// 设置私钥为用户ID
    }

    /**
     * 兼容老版本
     * @param admin 管理员对象
     * @param timeout 有效期
     * @return
     */
    @Deprecated
    public static String getAdminToken(Object admin, Long timeout) {
        JSONObject json =(JSONObject) JSON.toJSON(admin);
        String uid = json.getString("id");
        return TokenUtils.getAdminToken(uid, timeout);
    }
}
