/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.auth.interceptor;

import cn.tworice.auth.config.AuthProperties;
import cn.tworice.auth.service.VerifyManger;
import cn.tworice.auth.util.TokenUtils;
import cn.tworice.common.util.RequestUtil;
import cn.tworice.common.util.StringUtils;
import cn.tworice.common.vo.RequestResult;
import cn.tworice.common.vo.StateCodeConst;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class AuthInterceptor
implements HandlerInterceptor {
    @Autowired
    private VerifyManger verifyManger;
    @Resource
    private AuthProperties authProperties;
    @Value(value="${tworice.login.tokenTimeout:86400000}")
    private long tokenTimeout;
    @Value(value="${tworice.dev:false}")
    private boolean dev;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        if (this.dev || request.getRequestURI().endsWith("template")) {
            return true;
        }
        String origin = request.getHeader("Origin");
        if (origin != null) {
            response.setHeader("Access-Control-Allow-Origin", "*");
            response.setHeader("Access-Control-Allow-Methods", "POST, GET, OPTIONS, DELETE, PUT, HEAD");
            response.setHeader("Access-Control-Allow-Headers", "Content-Type, Token, adminID");
            response.setHeader("Access-Control-Max-Age", "3600");
            response.setHeader("Access-Control-Expose-Headers", "New-Token");
        }
        try {
            String token = request.getHeader("token");
            String adminID = request.getHeader("adminID");
            String url = request.getRequestURI();
            if (StringUtils.isEmpty((String)token) || !this.verifyManger.auth(adminID, token, url)) {
                RequestUtil.returnJson((HttpServletResponse)response, (RequestResult)RequestResult.error((Integer)StateCodeConst.LOGIN_ERROR, (String)"\u8bf7\u8fdb\u884c\u767b\u5f55"));
                return false;
            }
            DecodedJWT decode = JWT.decode((String)token);
            Algorithm algorithm = Algorithm.HMAC256((String)adminID);
            algorithm.verify(decode);
            Date expiresAt = decode.getExpiresAt();
            if (expiresAt.getTime() < System.currentTimeMillis()) {
                RequestUtil.returnJson((HttpServletResponse)response, (RequestResult)RequestResult.error((Integer)StateCodeConst.LOGIN_ERROR, (String)"Token\u672a\u6388\u6743\u6216\u5df2\u8d85\u65f6"));
                return false;
            }
            if (expiresAt.getTime() < System.currentTimeMillis() + this.authProperties.getRefreshTime()) {
                String newToken = TokenUtils.getAdminToken(adminID, (Long)this.tokenTimeout);
                response.setHeader("New-Token", newToken);
                this.verifyManger.refresh(adminID, newToken);
            }
            return true;
        }
        catch (JWTDecodeException ex) {
            RequestUtil.returnJson((HttpServletResponse)response, (RequestResult)RequestResult.error((Integer)StateCodeConst.LOGIN_ERROR, (String)"Token\u683c\u5f0f\u4e0d\u5408\u6cd5"));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return false;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}

