package cn.tworice.auth.service;

import java.util.Map;

/**
 * 核验用户是否登录过
 **/
public interface VerifyManger {

    /**
     * 用户上线
     * 将用户的Key和获取的Token保存起来
     * @param key 用户Key
     * @param token 用户的Token
     * @return boolean 是否保存成功
     * @author 二饭 [2022/11/6]
     **/
    boolean online(String key,String token);

    /**
     * 刷新Token
     * @param key 用户Key
     * @param newToken 新Token
     * @return 是否刷新成功
     */
    boolean refresh(String key, String newToken);

    /**
     * 获取目前在线的用户列表
     * @return  <用户Key，用户Token>
     * @author 二饭 [2022/11/6]
     **/
    Map<String, String> onlineMap();

    /**
     * 用户下线，根据用户Key执行该用户的下线登出操作
     * @param key 用户Key
     * @return boolean 是否成功登出
     * @author 二饭 [2022/11/6]
     **/
    boolean offline(String key);

    /**
     * 核验用户是否在线
     * @param key 用户
     * @param token 用户Token
     * @return boolean 用户在线返回True
     * @author 二饭 [2022/11/6]
     **/
    boolean exist(String key,String token);

    /**
     * 核验用户是否有该资源的权限
     * @param key 用户Key
     * @param token 用户Token
     * @param url 用户要访问的资源
     * @return boolean 如果用户可以访问该资源返回True
     * @author 二饭 [2022/11/6]
     **/
    boolean auth(String key,String token,String url);

    /**
     * 设置用户的资源列表
     * @param adminID 用户ID
     * @param resources 用户资源列表
     * @return boolean
     * @author 二饭 [2022/11/6]
     **/
    boolean addAdminResources(String adminID,String[] resources);
}
