/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.auth.service.impl;

import cn.tworice.auth.config.AuthProperties;
import cn.tworice.auth.service.AuthManager;
import cn.tworice.common.framework.mail.core.MailExecutor;
import cn.tworice.common.util.NetworkUtil;
import cn.tworice.common.util.StringUtils;
import cn.tworice.common.vo.RequestResult;
import cn.tworice.common.vo.StateCodeConst;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DefaultAuthManager
implements AuthManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultAuthManager.class);
    @Resource
    private AuthProperties authProperties;
    @Resource
    private MailExecutor mailExecutor;
    private final ConcurrentHashMap<String, CopyOnWriteArrayList<Long>> ipFailureRecords = new ConcurrentHashMap();
    private final ConcurrentHashMap.KeySetView<String, Boolean> bannedIPs = ConcurrentHashMap.newKeySet();

    @Override
    public boolean auth(HttpServletRequest request, HttpServletResponse response) {
        if (!this.authProperties.getBlast().booleanValue()) {
            return true;
        }
        String clientIP = NetworkUtil.getClientIP((HttpServletRequest)request);
        if (this.bannedIPs.contains(clientIP)) {
            this.returnJson(response, "\u8be5IP\u5df2\u88ab\u5c01\u7981\uff0c\u7981\u6b62\u767b\u5f55");
            return false;
        }
        this.cleanExpiredRecords(clientIP);
        int failureCount = this.ipFailureRecords.getOrDefault(clientIP, new CopyOnWriteArrayList()).size();
        if (failureCount >= this.authProperties.getBlastCount()) {
            this.bannedIPs.add(clientIP);
            this.ipFailureRecords.remove(clientIP);
            if (!StringUtils.isEmpty((String)this.authProperties.getMailBlast())) {
                this.mailExecutor.sendMail(this.authProperties.getMailBlast(), "\u68c0\u6d4b\u5230\u6076\u610f\u767b\u5f55\u8bf7\u6c42", "IP\u5730\u5740\uff1a" + clientIP + "\uff0c\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef\u6b21\u6570\u8fc7\u591a\uff0c\u7cfb\u7edf\u5df2\u81ea\u52a8\u5c01\u7981");
            }
            this.returnJson(response, "\u767b\u5f55\u5931\u8d25\u6b21\u6570\u8fc7\u591a\uff0cIP\u5df2\u88ab\u5c01\u7981");
            return false;
        }
        return true;
    }

    @Override
    public void record(HttpServletRequest request) {
        if (!this.authProperties.getBlast().booleanValue()) {
            return;
        }
        String clientIP = NetworkUtil.getClientIP((HttpServletRequest)request);
        long currentTime = System.currentTimeMillis();
        this.ipFailureRecords.computeIfAbsent(clientIP, k -> new CopyOnWriteArrayList()).add(currentTime);
    }

    private void cleanExpiredRecords(String clientIP) {
        CopyOnWriteArrayList<Long> records = this.ipFailureRecords.get(clientIP);
        if (records == null) {
            return;
        }
        long threshold = System.currentTimeMillis() - 60000L;
        records.removeIf(timestamp -> timestamp < threshold);
        if (records.isEmpty()) {
            this.ipFailureRecords.remove(clientIP);
        }
    }

    private void returnJson(HttpServletResponse response, String message) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        RequestResult result = new RequestResult(StateCodeConst.LOGIN_ERROR.intValue(), message);
        try (PrintWriter writer = response.getWriter();){
            writer.print(JSON.toJSONString((Object)result));
        }
        catch (IOException e) {
            System.err.println("\u54cd\u5e94\u8f93\u51fa\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }
}

