package cn.tworice.backup.controller;

import cn.tworice.backup.executor.DatabaseParam;
import cn.tworice.backup.service.BackupService;
import cn.tworice.common.vo.RequestResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@RestController
@RequestMapping("admin/backup")
@Slf4j
@CrossOrigin
@Api(tags = "数据库备份")
public class BackupController {

    @Resource
    private BackupService backupService;

    @PostMapping("")
    @ApiOperation("备份数据库文件")
    public RequestResult backup(DatabaseParam param) {
        backupService.backup(param);
        return RequestResult.success();
    }

    @PostMapping("dayTiming")
    @ApiOperation("每日定时备份数据库文件")
    public RequestResult timing(DatabaseParam param, @ApiParam("时") int hour, @ApiParam("分") int minute) {
        backupService.scheduleTaskAtSpecificTime(param,hour,minute);
        return RequestResult.success();
    }

    @PostMapping("timing")
    @ApiOperation("每日定时备份数据库文件")
    public RequestResult timing(DatabaseParam param, @ApiParam("Cron 表达式") String cron) {
        backupService.scheduleTaskAtSpecificTime(param,cron);
        return RequestResult.success();
    }
}
