package cn.tworice.backup.executor;

import cn.tworice.backup.executor.impl.MySQLBackupExecutor;
import cn.tworice.common.util.StringUtils;
import lombok.Getter;

import java.lang.reflect.Parameter;

@Getter
public enum DatabaseEnum {

    MYSQL("mysql", MySQLBackupExecutor.class);

    private final String type;

    private final Class<? extends BackupExecutor> clazz;

    DatabaseEnum(String type, Class<? extends BackupExecutor> clazz) {
        this.type = type;
        this.clazz = clazz;
    }

    public static DatabaseEnum getExecutorByType(String type) {
        if (StringUtils.isBlank(type)) {
            return null;
        }
        for (DatabaseEnum executor : values()) {
            if (executor.getType().equals(type)) {
                return executor;
            }
        }
        return null;
    }
    DatabaseEnum() {
        this.type = null;
        this.clazz = null;
    }
}
