/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.backup.executor.impl;

import cn.tworice.backup.executor.BackupExecutor;
import cn.tworice.backup.executor.DatabaseParam;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MySQLBackupExecutor
implements BackupExecutor {
    private Connection connection = null;
    private Statement statement = null;
    private DatabaseParam dataSourceProperties;

    public MySQLBackupExecutor(DatabaseParam params) {
        this.dataSourceProperties = params;
    }

    public MySQLBackupExecutor() {
    }

    @Override
    public void backup(StringBuilder path) {
        try {
            this.connectSQL();
            this.exportAllTableSchemas(path);
            this.connection.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void connectSQL() throws SQLException {
        try {
            Class.forName(this.dataSourceProperties.getDriver()).newInstance();
            this.connection = DriverManager.getConnection(this.dataSourceProperties.getUrl(), this.dataSourceProperties.getUsername(), this.dataSourceProperties.getPassword());
            this.statement = this.connection.createStatement();
        }
        catch (Exception e) {
            this.connection.close();
            throw new RuntimeException("\u521b\u5efa\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public void exportAllTableSchemas(StringBuilder path) throws SQLException {
        String dateString = this.getDateString();
        path.append(File.separator).append(this.dataSourceProperties.getDatabaseName()).append("_").append(dateString).append(".sql");
        File file = new File(path.toString());
        file.getParentFile().mkdirs();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file, true));){
            ResultSet resultSet = this.statement.executeQuery("SHOW TABLES FROM " + this.dataSourceProperties.getDatabaseName());
            while (resultSet.next()) {
                String tableName = resultSet.getString(1);
                writer.write("/* \u8868\u540d\uff1a" + tableName + " */");
                writer.newLine();
                Statement innerStatement = this.connection.createStatement();
                ResultSet tableResult = innerStatement.executeQuery("SHOW CREATE TABLE " + this.dataSourceProperties.getDatabaseName() + "." + tableName);
                if (tableResult.next()) {
                    String createTableSQL = tableResult.getString(2);
                    writer.write(createTableSQL + ";");
                    writer.newLine();
                    this.exportDataToInsert(tableName, writer);
                    writer.newLine();
                }
                tableResult.close();
                innerStatement.close();
            }
        }
        catch (Exception e) {
            this.connection.close();
            throw new RuntimeException(e);
        }
    }

    private String getDateString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm");
        return sdf.format(new Date());
    }

    private void exportDataToInsert(String tableName, BufferedWriter writer) {
        try (Statement statement = this.connection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT * FROM " + tableName);){
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            while (resultSet.next()) {
                StringBuilder insertStatement = new StringBuilder();
                insertStatement.append("INSERT INTO `").append(tableName).append("` VALUES (");
                for (int i = 1; i <= columnCount; ++i) {
                    Object value = resultSet.getObject(i);
                    if (value != null) {
                        insertStatement.append("'").append(value).append("'");
                    } else {
                        insertStatement.append("NULL");
                    }
                    if (i >= columnCount) continue;
                    insertStatement.append(", ");
                }
                insertStatement.append(");");
                writer.write(insertStatement.toString());
                writer.newLine();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

