/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.backup.service;

import cn.tworice.backup.executor.BackupExecutor;
import cn.tworice.backup.executor.DatabaseEnum;
import cn.tworice.backup.executor.DatabaseParam;
import cn.tworice.backup.scheduler.BackupScheduledTask;
import cn.tworice.common.framework.mail.bo.Attachment;
import cn.tworice.common.framework.mail.bo.SendMailBO;
import cn.tworice.common.framework.mail.core.MailExecutor;
import cn.tworice.common.util.StringUtils;
import java.io.File;
import java.util.Collections;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Service;

@Service
public class BackupService {
    private static final Logger log = LoggerFactory.getLogger(BackupService.class);
    @Value(value="${tworice.backup.path:''}")
    private String path;
    @Resource
    private MailExecutor mailExecutor;
    @Resource
    private DataSourceProperties dataSourceProperties;
    @Value(value="${tworice.backup.email:''}")
    private String email;
    @Value(value="${tworice.backup.cron:0 0 2 * * *}")
    private String cron;
    @Value(value="${tworice.backup.enabled:false}")
    private Boolean enabled;
    @Resource
    private BackupScheduledTask backupScheduledTask;

    @PostConstruct
    public void init() {
        if (!this.enabled.booleanValue()) {
            return;
        }
        DatabaseParam param = new DatabaseParam();
        param.setDatabaseName(this.getDatabaseName(this.dataSourceProperties.getUrl()));
        param.setType(this.getType(this.dataSourceProperties.getUrl()));
        param.setUrl(this.dataSourceProperties.getUrl());
        param.setDriver(this.dataSourceProperties.getDriverClassName());
        param.setUsername(this.dataSourceProperties.getUsername());
        param.setPassword(this.dataSourceProperties.getPassword());
        param.setEmail(this.email);
        log.info("\u521d\u59cb\u5316\u6570\u636e\u5e93\u5907\u4efd\u8ba1\u5212\uff1a{},\u5468\u671f\uff1a{}", (Object)param, (Object)this.cron);
        this.scheduleTaskAtSpecificTime(param, this.cron);
    }

    public void scheduleTaskAtSpecificTime(DatabaseParam param, int hour, int minute) {
        CronTrigger trigger = new CronTrigger(String.format("0 %d %d * * *", minute, hour));
        this.backupScheduledTask.scheduleTask(param, (Trigger)trigger);
    }

    public void scheduleTaskAtSpecificTime(DatabaseParam param, String cron) {
        CronTrigger trigger = new CronTrigger(cron);
        this.backupScheduledTask.scheduleTask(param, (Trigger)trigger);
    }

    public void backup(DatabaseParam param) {
        BackupExecutor executor = this.getBackupExecutorByType(param);
        this.path = StringUtils.isBlank((String)this.path) ? System.getProperty("user.dir") + File.separator + "backup" : System.getProperty("user.dir") + File.separator + this.path;
        StringBuilder builder = new StringBuilder(this.path);
        executor.backup(builder);
        log.info("\u6570\u636e\u5e93\u5907\u4efd\u6267\u884c\u6210\u529f\uff1a{}", (Object)builder);
        this.sendMail(builder.toString(), param);
    }

    public BackupExecutor getBackupExecutorByType(DatabaseParam param) {
        DatabaseEnum executorByType = DatabaseEnum.getExecutorByType(param.getType());
        if (executorByType == null) {
            throw new RuntimeException("\u672a\u627e\u5230\u6570\u636e\u5e93\u7c7b\u578b");
        }
        try {
            return executorByType.getClazz().getConstructor(DatabaseParam.class).newInstance(param);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void sendMail(String path, DatabaseParam param) {
        if (StringUtils.isBlank((String)param.getEmail()) || StringUtils.isBlank((String)path)) {
            return;
        }
        SendMailBO sendMailBO = new SendMailBO();
        sendMailBO.setTo(param.getEmail());
        sendMailBO.setSubject("\u3010\u6570\u636e\u5e93\u5907\u4efd\u3011" + param.getDatabaseName());
        sendMailBO.setSimple(Boolean.valueOf(false));
        sendMailBO.setContent("\u6570\u636e\u5e93\u5907\u4efd");
        File file = new File(path);
        Attachment attachment = new Attachment();
        attachment.setName(file.getName());
        attachment.setFile(file);
        sendMailBO.setAttachment(Collections.singletonList(attachment));
        this.mailExecutor.sendMail(sendMailBO);
    }

    private String getDatabaseName(String url) {
        String[] urlParts = url.split("/");
        return urlParts[urlParts.length - 1].split("\\?")[0];
    }

    private String getType(String url) {
        String[] urlParts = url.split(":");
        return urlParts[1];
    }
}

