/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.backup.executor;

import cn.tworice.backup.executor.BackupExecutor;
import cn.tworice.backup.executor.impl.MySQLBackupExecutor;
import cn.tworice.common.util.StringUtils;

public enum DatabaseEnum {
    MYSQL("mysql", MySQLBackupExecutor.class);

    private final String type;
    private final Class<? extends BackupExecutor> clazz;

    private DatabaseEnum(String type, Class<? extends BackupExecutor> clazz) {
        this.type = type;
        this.clazz = clazz;
    }

    public static DatabaseEnum getExecutorByType(String type) {
        if (StringUtils.isBlank((String)type)) {
            return null;
        }
        for (DatabaseEnum executor : DatabaseEnum.values()) {
            if (!executor.getType().equals(type)) continue;
            return executor;
        }
        return null;
    }

    private DatabaseEnum() {
        this.type = null;
        this.clazz = null;
    }

    public String getType() {
        return this.type;
    }

    public Class<? extends BackupExecutor> getClazz() {
        return this.clazz;
    }
}

