/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.backup.scheduler;

import cn.tworice.backup.executor.DatabaseParam;
import cn.tworice.backup.service.BackupService;
import java.util.concurrent.ScheduledFuture;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.stereotype.Service;

@Service
public class BackupScheduledTask {
    private static final Logger log = LoggerFactory.getLogger(BackupScheduledTask.class);
    @Resource
    private ThreadPoolTaskScheduler backupTaskScheduler;
    ScheduledFuture<?> scheduledFuture;
    @Resource
    private BackupService backupService;

    public void scheduleTask(DatabaseParam param, Trigger trigger) {
        Runnable task = () -> {
            log.info("\u5f00\u59cb\u6267\u884c\u5b9a\u65f6\u5907\u4efd\u6570\u636e\u5e93\u4efb\u52a1");
            this.backupService.backup(param);
        };
        if (this.scheduledFuture != null && !this.scheduledFuture.isDone()) {
            this.scheduledFuture.cancel(true);
        }
        this.scheduledFuture = this.backupTaskScheduler.schedule(task, trigger);
    }
}

