package cn.tworice.banner;

import cn.tworice.common.order.ApplicationListenerOrder;
import cn.tworice.common.util.spring.ApplicationUtil;
import lombok.SneakyThrows;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

import java.net.InetAddress;


@Component
@Order(0)
public class AppBanner implements ApplicationListener<ApplicationReadyEvent>, Ordered {

    @SneakyThrows
    @Override
    public void onApplicationEvent(ApplicationReadyEvent applicationReadyEvent) {
        Environment env = ApplicationUtil.getApplicationContext().getEnvironment();
        String port = env.getProperty("server.port");
        String ip = InetAddress.getLocalHost().getHostAddress();
        System.out.print("----------------------------------------------\n\t"+
                "Application is running!\n\t"+
                "Local:\t\thttp://localhost:"+port+"\n\t"+
                "External:\thttp://"+ip+":"+port+"\n"+
                "Swagger API:\thttp://"+ip+":"+port+"/doc.html\n"+
                "----------------------------------------------\n");
    }

    @Override
    public int getOrder() {
        return ApplicationListenerOrder.Banner_ORDER;
    }
}
