package cn.tworice.captcha.core;


import cn.tworice.captcha.constand.CaptchaType;
import com.wf.captcha.ArithmeticCaptcha;
import com.wf.captcha.SpecCaptcha;
import com.wf.captcha.base.Captcha;
import lombok.Getter;
import lombok.Setter;

/**
 * @author 二饭
 */
@Getter
public class CaptchaBase64 {

    /**
     *  获取结果字符串
     */
    private String result;

    @Setter
    private String key;

    private final Integer defaultWidth = 130;

    private final Integer defaultHeight = 48;

    private final Integer defaultLength = 2;

    private Captcha captcha;

    public CaptchaBase64(String type) {
        if (CaptchaType.character.equals(type)) {
            getCharCaptcha();
        } else {
            getArithmeticCaptcha();
        }
    }

    public CaptchaBase64(String type, Integer width, Integer height, Integer defaultLength) {
        if (CaptchaType.character.equals(type)) {
            getCharCaptcha(width, height, defaultLength);
        } else {
            getArithmeticCaptcha(width, height, defaultLength);
        }
    }

    public String getCaptcha() {
        return captcha.toBase64();
    }

    public void getArithmeticCaptcha() {
        captcha = new ArithmeticCaptcha(defaultWidth, defaultHeight, defaultLength);
        this.result = captcha.text();
    }

    /**
     * 生成算数验证码，并以Base64形式返回
     * 指定验证码的宽度和高度
     * @param width 尺寸-宽度px
     * @param height 尺寸-高度px
     * @param len 几位数运算
     */
    public void getArithmeticCaptcha(int width, int height, int len) {
        captcha = new ArithmeticCaptcha(width, height, len);
        this.result = captcha.text();
    }

    /**
     * 生成字符验证码，并以Base64形式返回
     * 默认以 width-130，height-48尺寸 5位字符输出
     * @return 验证码图片Base64
     */
    public void getCharCaptcha(){
        captcha = new SpecCaptcha(defaultWidth, defaultHeight);
        this.result = captcha.text();
    }

    /**
     * 生成字符验证码，并以Base64形式返回
     * @param width 尺寸-宽度px
     * @param height 尺寸-高度px
     * @param len 字符位数
     */
    public void getCharCaptcha(int width, int height,int len) {
        captcha = new SpecCaptcha(width, height, len);
        this.result = captcha.text();
    }


}
