/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.captcha.core;

import com.wf.captcha.ArithmeticCaptcha;
import com.wf.captcha.SpecCaptcha;
import com.wf.captcha.base.Captcha;

public class CaptchaBase64 {
    private String result;
    private String key;
    private final Integer defaultWidth = 130;
    private final Integer defaultHeight = 48;
    private final Integer defaultLength = 2;
    private Captcha captcha;

    public CaptchaBase64(String type) {
        if ("character".equals(type)) {
            this.getCharCaptcha();
        } else {
            this.getArithmeticCaptcha();
        }
    }

    public CaptchaBase64(String type, Integer width, Integer height, Integer defaultLength) {
        if ("character".equals(type)) {
            this.getCharCaptcha(width, height, defaultLength);
        } else {
            this.getArithmeticCaptcha(width, height, defaultLength);
        }
    }

    public String getCaptcha() {
        return this.captcha.toBase64();
    }

    public void getArithmeticCaptcha() {
        this.captcha = new ArithmeticCaptcha(this.defaultWidth.intValue(), this.defaultHeight.intValue(), this.defaultLength.intValue());
        this.result = this.captcha.text();
    }

    public void getArithmeticCaptcha(int width, int height, int len) {
        this.captcha = new ArithmeticCaptcha(width, height, len);
        this.result = this.captcha.text();
    }

    public void getCharCaptcha() {
        this.captcha = new SpecCaptcha(this.defaultWidth.intValue(), this.defaultHeight.intValue());
        this.result = this.captcha.text();
    }

    public void getCharCaptcha(int width, int height, int len) {
        this.captcha = new SpecCaptcha(width, height, len);
        this.result = this.captcha.text();
    }

    public String getResult() {
        return this.result;
    }

    public String getKey() {
        return this.key;
    }

    public Integer getDefaultWidth() {
        return this.defaultWidth;
    }

    public Integer getDefaultHeight() {
        return this.defaultHeight;
    }

    public Integer getDefaultLength() {
        return this.defaultLength;
    }

    public void setKey(String key) {
        this.key = key;
    }
}

