package cn.tworice.chatbot.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

import javax.validation.constraints.NotNull;

@Data
@Component
@ConfigurationProperties(prefix = "tworice.chatbot")
@Validated
public class ChatBotProperties {
    @NotNull(message = "API key cannot be null")
    private String apiKey;

    @NotNull(message = "Secret key cannot be null")
    private String secretKey;

    private String clientType = "baidu";

    private String model = "ERNIE-Speed-128K";
}
