package cn.tworice.chatbot.core.client.sizhi;

import cn.tworice.chatbot.config.ChatBotProperties;
import cn.tworice.chatbot.core.bo.ChatMessage;
import cn.tworice.chatbot.core.client.ChatBotClient;
import com.alibaba.fastjson.JSONObject;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.util.List;

public class SizhiClient implements ChatBotClient {

    @Resource
    private RestTemplate restTemplate;

    @Resource
    private ChatBotProperties chatBotProperties;

    @Override
    public String chat(String question, List<ChatMessage> msg) {
        String result = restTemplate.getForEntity(
                "https://api.sizhi.com/chat?appid=" + chatBotProperties.getApiKey() +
                        "&userid=" + msg.get(0).getName() +
                        "&spoken=" + question, String.class).getBody();
        if (result == null || result.isEmpty()) {
            return "暂无内容";
        }
        JSONObject body = JSONObject.parseObject(result);
        if(body.getInteger("status") == 0){
            return body.getJSONObject("data").getJSONObject("info").getString("text");
        } else {
            return body.getString("message");
        }
    }

    @Override
    public String getRoleUser() {
        return null;
    }

    @Override
    public String getRoleAssistant() {
        return null;
    }
}
