package cn.tworice.chatbot.config;

import cn.tworice.chatbot.core.client.ChatBotClient;
import cn.tworice.chatbot.core.client.baidu.BaiduClient;
import cn.tworice.chatbot.core.client.sizhi.SizhiClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Resource;

@Configuration
public class ChatBotConfig {

    @Resource
    private ChatBotProperties chatBotProperties;

    @Bean
    public ChatBotClient chatBotClient() {
        switch (chatBotProperties.getClientType()) {
            case "baidu":
                return new BaiduClient();
            case "zhizi":
                return new SizhiClient();
        }
        throw new RuntimeException("不支持的模型类型");
    }
}
