package cn.tworice;

import java.util.HashMap;
import java.util.Map;

public class MemoryClassLoader extends ClassLoader {
    private final Map<String, byte[]> classBytesMap;

    public MemoryClassLoader(Map<String, byte[]> classBytesMap) {
        this.classBytesMap = new HashMap<>(classBytesMap);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] bytes = classBytesMap.get(name);
        if (bytes == null) {
            throw new ClassNotFoundException(name);
        }
        return defineClass(name, bytes, 0, bytes.length);
    }
}
