/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.desensitize.slider.handler;

import cn.tworice.desensitize.base.handler.DesensitizationHandler;
import java.lang.annotation.Annotation;

public abstract class AbstractSliderDesensitizationHandler<T extends Annotation>
implements DesensitizationHandler<T> {
    @Override
    public String desensitize(String origin, T annotation) {
        int prefixKeep = this.getPrefixKeep(annotation);
        int suffixKeep = this.getSuffixKeep(annotation);
        String replacer = this.getReplacer(annotation);
        int length = origin.length();
        if (prefixKeep >= length || suffixKeep >= length) {
            return this.buildReplacerByLength(replacer, length);
        }
        if (prefixKeep + suffixKeep >= length) {
            return this.buildReplacerByLength(replacer, length);
        }
        int interval = length - prefixKeep - suffixKeep;
        return origin.substring(0, prefixKeep) + this.buildReplacerByLength(replacer, interval) + origin.substring(prefixKeep + interval);
    }

    private String buildReplacerByLength(String replacer, int length) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append(replacer);
        }
        return builder.toString();
    }

    abstract Integer getPrefixKeep(T var1);

    abstract Integer getSuffixKeep(T var1);

    abstract String getReplacer(T var1);
}

