package cn.tworice.dict.service;



import cn.tworice.dict.dao.po.DictValueDO;
import cn.tworice.common.util.excel.InductsListenerService;
import cn.tworice.dict.dao.DictValueDao;
import cn.tworice.mybatis.query.LambdaQueryWrapperX;
import cn.tworice.mybatis.vo.PageParam;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@Service
public class DictValueService implements InductsListenerService<DictValueDO> {

    @Resource
    private DictValueDao dao;

    public Map<String,Object> list(PageParam pageParam, DictValueDO entity) {
        return dao.selectPage(pageParam,new LambdaQueryWrapperX<DictValueDO>()
                .eqIfPresent(DictValueDO::getId,entity.getId())
                .eqIfPresent(DictValueDO::getDict,entity.getDict())
                .likeIfPresent(DictValueDO::getContent,entity.getContent())
        );
    }

    public int set(DictValueDO entity) {
        if (entity.getId() == null) {
            entity.setCreateTime(System.currentTimeMillis());
            return dao.insert(entity);
        } else {
            return dao.updateById(entity);
        }
    }

    public int del(Integer[] ids) {
        return dao.deleteBatchIds(Arrays.asList(ids));
    }

    public boolean update(DictValueDO entity) {
        return dao.updateById(entity)>0;
    }

    public DictValueDO info(int id) {
        return dao.selectById(id);
    }

    @Override
    public boolean saveBatch(List<DictValueDO> list) {
        list.forEach(item -> {
            item.setCreateTime(System.currentTimeMillis());
        });
        return dao.insertBatch(list,list.size());
    }

}