/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.document.doc;

import cn.tworice.common.util.CollectionUtil;
import cn.tworice.common.util.StringUtils;
import cn.tworice.document.config.DocumentProperties;
import cn.tworice.document.vo.DownloadRequestVO;
import cn.tworice.document.vo.GenerateResVO;
import cn.tworice.upload.service.UploadUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFStyle;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHpsMeasure;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSpacing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DocxExecutor {
    private static final Logger log = LoggerFactory.getLogger(DocxExecutor.class);
    @Resource
    private UploadUtil uploadUtil;
    @Resource
    private DocumentProperties documentProperties;
    private final Pattern pattern = Pattern.compile("\\$\\{(.*?)\\}");
    private final Map<String, List<String>> variableMap = new HashMap<String, List<String>>();

    public void cacheClear() {
        this.variableMap.clear();
    }

    public List<String> loadVariable(String inputFilePath) {
        if (this.variableMap.containsKey(inputFilePath)) {
            return this.variableMap.get(inputFilePath);
        }
        ArrayList<String> variables = new ArrayList<String>();
        try (FileInputStream fis = new FileInputStream(this.getDocumentPath(inputFilePath));
             XWPFDocument document = new XWPFDocument((InputStream)fis);){
            for (XWPFParagraph paragraph : document.getParagraphs()) {
                this.loadText(paragraph, variables);
            }
            for (XWPFTable table : document.getTables()) {
                for (XWPFTableRow row : table.getRows()) {
                    for (XWPFTableCell cell : row.getTableCells()) {
                        for (XWPFParagraph paragraph : cell.getParagraphs()) {
                            this.loadText(paragraph, variables);
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef");
        }
        this.variableMap.put(inputFilePath, variables);
        return variables;
    }

    public void processDocx(ByteArrayOutputStream outputStream, DownloadRequestVO vo) {
        try (FileInputStream fis = new FileInputStream(this.getDocumentPath(vo.getPath()));
             XWPFDocument document = new XWPFDocument((InputStream)fis);){
            Map<String, String> replacements = this.buildReplacements(vo.getVariables());
            List paragraphList = document.getParagraphs();
            for (int i = 0; i < paragraphList.size(); ++i) {
                XWPFParagraph paragraph = (XWPFParagraph)paragraphList.get(i);
                this.processText(document, paragraph, replacements);
            }
            for (XWPFTable table : document.getTables()) {
                for (XWPFTableRow row : table.getRows()) {
                    for (XWPFTableCell cell : row.getTableCells()) {
                        List paragraphs = cell.getParagraphs();
                        if (!CollectionUtil.isNotEmpty((Collection)paragraphs)) continue;
                        for (int i = 0; i < paragraphs.size(); ++i) {
                            this.processTextToTable(cell, (XWPFParagraph)paragraphs.get(i), replacements);
                        }
                    }
                }
            }
            document.write((OutputStream)outputStream);
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef", (Throwable)e);
        }
    }

    private void processText(XWPFDocument document, XWPFParagraph paragraph, Map<String, String> replacements) {
        Matcher matcher = this.pattern.matcher(paragraph.getText());
        while (matcher.find()) {
            String variable = matcher.group(1);
            String replacement = replacements.getOrDefault(variable, matcher.group(0));
            this.replaceParagraphText(document, paragraph, this.getLines(replacement));
        }
    }

    private void processTextToTable(XWPFTableCell tableCell, XWPFParagraph paragraph, Map<String, String> replacements) {
        String text = paragraph.getText();
        Matcher matcher = this.pattern.matcher(text);
        while (matcher.find()) {
            String variable = matcher.group(1);
            String replacement = replacements.getOrDefault(variable, matcher.group(0));
            this.replaceCellParagraphText(tableCell, paragraph, this.getLines(replacement));
        }
    }

    private void replaceParagraphText(XWPFDocument document, XWPFParagraph paragraph, String[] lines) {
        if (lines == null || lines.length == 0) {
            return;
        }
        List runs = paragraph.getRuns();
        int beginRun = -1;
        int endRun = -1;
        int beginIndex = -1;
        int endIndex = -1;
        for (int i = 0; i < runs.size(); ++i) {
            XWPFRun run = (XWPFRun)runs.get(i);
            String text = run.text();
            if (beginRun == -1 && text.contains("$")) {
                beginRun = i;
                beginIndex = text.indexOf("$");
            }
            if (endRun == -1 && text.contains("}")) {
                endRun = i;
                endIndex = text.indexOf("}");
            }
            if (beginRun != -1 && endRun != -1) break;
        }
        if (beginRun == -1 || endRun == -1) {
            return;
        }
        if (beginRun == endRun) {
            this.replaceTextInSameRun((XWPFRun)runs.get(beginRun), beginIndex, endIndex, lines[0]);
        } else {
            this.replaceTextInMultipleRuns(runs, beginRun, endRun, beginIndex, endIndex, lines[0]);
        }
        this.continuedWritingLine(lines, document, paragraph);
    }

    private void replaceTextInSameRun(XWPFRun run, int beginIndex, int endIndex, String replacement) {
        String text = run.text();
        String result = StringUtils.replaceSubstring((String)text, (int)beginIndex, (int)endIndex, (String)replacement);
        run.setText(result, 0);
    }

    private void replaceTextInMultipleRuns(List<XWPFRun> runs, int beginRun, int endRun, int beginIndex, int endIndex, String replacement) {
        this.setBeginAndEndRun(runs.get(beginRun), runs.get(endRun), beginIndex, endIndex);
        for (int i = endRun - 1; i > beginRun; --i) {
            runs.get(i).setText("", 0);
        }
        runs.get(endRun - 1).setText(replacement, 0);
    }

    private void continuedWritingLine(String[] lines, XWPFDocument document, XWPFParagraph paragraph) {
        for (int i = 1; i < lines.length; ++i) {
            int paragraphIndex = document.getParagraphs().indexOf(paragraph);
            XWPFParagraph newParagraph = document.getParagraphs().size() - 1 == paragraphIndex ? document.createParagraph() : document.insertNewParagraph(((XWPFParagraph)document.getParagraphs().get(paragraphIndex + 1)).getCTP().newCursor());
            XWPFRun newRun = newParagraph.createRun();
            newRun.setText(lines[i]);
            this.copyFormatting(newParagraph, paragraph);
            paragraph = newParagraph;
        }
    }

    private void setBeginAndEndRun(XWPFRun beginRun, XWPFRun endRun, int beginIndex, int endIndex) {
        if (beginRun.text().length() == 1) {
            beginRun.setText("", 0);
        } else {
            beginRun.setText(beginRun.text().substring(0, beginIndex), 0);
        }
        if (endRun.text().length() == 1) {
            endRun.setText("", 0);
        } else {
            endRun.setText(endRun.text().substring(endIndex), 0);
        }
    }

    private void replaceCellParagraphText(XWPFTableCell cell, XWPFParagraph paragraph, String[] lines) {
        int i;
        if (lines == null || lines.length == 0) {
            return;
        }
        for (i = paragraph.getRuns().size() - 1; i >= 0; --i) {
            paragraph.removeRun(i);
        }
        paragraph.createRun().setText(lines[0]);
        for (i = 1; i < lines.length; ++i) {
            if (StringUtils.isBlank((String)lines[i])) continue;
            XWPFParagraph newParagraph = cell.addParagraph();
            XWPFRun newRun = newParagraph.createRun();
            newRun.setText(lines[i]);
            this.copyFormatting(newParagraph, paragraph);
        }
    }

    private void copyFormatting(XWPFParagraph newParagraph, XWPFParagraph oldParagraph) {
        CTSpacing oldSpacing;
        CTHpsMeasure sz;
        XWPFStyle style;
        newParagraph.setIndentationFirstLine(oldParagraph.getIndentationFirstLine());
        newParagraph.setAlignment(oldParagraph.getAlignment());
        if (newParagraph.getRuns().isEmpty() || oldParagraph.getRuns().isEmpty()) {
            return;
        }
        int fontSize = ((XWPFRun)oldParagraph.getRuns().get(0)).getFontSize();
        if (fontSize == -1 && oldParagraph.getStyle() != null && (style = oldParagraph.getDocument().getStyles().getStyle(oldParagraph.getStyle())) != null && style.getCTStyle().isSetRPr() && (sz = style.getCTStyle().getRPr().getSz()) != null && sz.getVal() != null) {
            fontSize = sz.getVal().intValue() / 2;
        }
        if (fontSize != -1) {
            ((XWPFRun)newParagraph.getRuns().get(0)).setFontSize(fontSize);
        }
        if ((oldSpacing = oldParagraph.getCTP().getPPr().getSpacing()) != null) {
            CTSpacing newSpacing;
            CTSpacing cTSpacing = newSpacing = newParagraph.getCTP().getPPr().isSetSpacing() ? newParagraph.getCTP().getPPr().getSpacing() : newParagraph.getCTP().getPPr().addNewSpacing();
            if (oldSpacing.isSetLine()) {
                newSpacing.setLine(oldSpacing.getLine());
                newSpacing.setLineRule(oldSpacing.getLineRule());
            }
            if (oldSpacing.isSetBefore()) {
                newSpacing.setBefore(oldSpacing.getBefore());
            }
            if (oldSpacing.isSetAfter()) {
                newSpacing.setAfter(oldSpacing.getAfter());
            }
        } else {
            newParagraph.setSpacingBetween(oldParagraph.getSpacingBetween());
        }
    }

    private void loadText(XWPFParagraph paragraph, List<String> variables) {
        String text = paragraph.getText();
        Matcher matcher = this.pattern.matcher(text);
        while (matcher.find()) {
            String variable = matcher.group(1);
            variables.add(variable);
        }
    }

    private String getDocumentPath(String filePath) {
        return this.uploadUtil.getUploadPath() + this.documentProperties.getDocument() + File.separator + filePath;
    }

    private Map<String, String> buildReplacements(List<GenerateResVO> variables) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        variables.forEach(item -> replacements.put(item.getVariable(), item.getValue()));
        return replacements;
    }

    private String[] getLines(String replacement) {
        if (StringUtils.isEmpty((String)replacement)) {
            return null;
        }
        return replacement.replace("\n\n", "\n").split("\n");
    }
}

