/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.document.visio;

import cn.tworice.document.config.DocumentProperties;
import cn.tworice.document.vo.DownloadRequestVO;
import cn.tworice.upload.service.UploadUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component
public class VisioExecutor {
    private static final Logger log = LoggerFactory.getLogger(VisioExecutor.class);
    @Resource
    private UploadUtil uploadUtil;
    @Resource
    private DocumentProperties documentProperties;

    public void processVisioFile(ByteArrayOutputStream outputStream, DownloadRequestVO vo) {
        try {
            ZipEntry entry;
            String filePath = this.getDocumentPath(vo.getPath());
            byte[] fileBytes = Files.readAllBytes(Paths.get(filePath, new String[0]));
            ByteArrayInputStream bais = new ByteArrayInputStream(fileBytes);
            ZipInputStream zis = new ZipInputStream(bais);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ZipOutputStream zos = new ZipOutputStream(baos);
            while ((entry = zis.getNextEntry()) != null) {
                int len;
                ByteArrayOutputStream tempBaos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((len = zis.read(buffer)) > 0) {
                    tempBaos.write(buffer, 0, len);
                }
                byte[] entryData = tempBaos.toByteArray();
                if (entry.getName().equals("visio/pages/page1.xml")) {
                    for (int i = vo.getVariables().size() - 1; i >= 0; --i) {
                        entryData = this.replaceStringInXml(entryData, vo.getVariables().get(i).getVariable(), vo.getVariables().get(i).getValue());
                    }
                }
                zos.putNextEntry(new ZipEntry(entry.getName()));
                zos.write(entryData);
                zos.closeEntry();
            }
            zis.close();
            zos.close();
            outputStream.write(baos.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private byte[] replaceStringInXml(byte[] xmlData, String targetString, String replacement) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        ByteArrayInputStream bais = new ByteArrayInputStream(xmlData);
        Document doc = builder.parse(bais);
        NodeList nodeList = doc.getElementsByTagName("*");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            NodeList children = node.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node child = children.item(j);
                if (child.getNodeType() != 3 || !child.getNodeValue().contains(targetString)) continue;
                child.setNodeValue(child.getNodeValue().replace(targetString, replacement));
            }
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(baos);
        transformer.transform(source, result);
        return baos.toByteArray();
    }

    private String getDocumentPath(String filePath) {
        return this.uploadUtil.getUploadPath() + this.documentProperties.getVisio() + File.separator + filePath;
    }
}

