/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.auth.util;

import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class KeySaving {
    public static final String PUBLIC_KEY_FILE = "public.key";
    public static final String PRIVATE_KEY_FILE = "private.key";
    public static final String TOKEN_FILE = "token";
    public static final String ENCRYPTED_KEY_FILE = "encrypted.key";

    public static void main(String[] args) throws Exception {
        SecretKey secretKey = KeySaving.generateSymmetricKey();
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        byte[] encryptedKey = KeySaving.encryptKey(secretKey, publicKey);
        KeySaving.saveKeyToFile(encryptedKey, ENCRYPTED_KEY_FILE);
        byte[] loadedKey = KeySaving.loadKeyFromFile(ENCRYPTED_KEY_FILE);
        SecretKey decryptedKey = KeySaving.decryptKey(loadedKey, privateKey);
        System.out.println("Decrypted Key: " + decryptedKey);
    }

    public static SecretKey generateSymmetricKey() throws Exception {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        keyGenerator.init(256);
        return keyGenerator.generateKey();
    }

    public static byte[] encryptKey(SecretKey secretKey, PublicKey publicKey) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, publicKey);
        return cipher.doFinal(secretKey.getEncoded());
    }

    public static SecretKey decryptKey(byte[] encryptedKey, PrivateKey privateKey) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, privateKey);
        byte[] decryptedKeyBytes = cipher.doFinal(encryptedKey);
        return new SecretKeySpec(decryptedKeyBytes, "AES");
    }

    public static void saveKeyToFile(byte[] keyData, String fileName) throws Exception {
        FileOutputStream fos = new FileOutputStream(fileName);
        fos.write(keyData);
        fos.close();
    }

    public static byte[] loadKeyFromFile(String fileName) throws Exception {
        return Files.readAllBytes(Paths.get(fileName, new String[0]));
    }
}

