package cn.tworice.feign;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

@FeignClient("Verify")
public interface VerifyFeign {

    /**
     * 上线Key和Token
     * @author 二饭 [2022/9/28]
     **/
    @PutMapping("/verify/online")
    public boolean online(@RequestParam("key") String key,@RequestParam("token") String token);

    /**
     * 获取当前在线用户列表
     * @return java.util.Map<java.lang.String, java.lang.String>
     * @author 二饭 [2022/9/28]
     **/
    @GetMapping("/verify/onlineMap")
    public Map<String, String> onlineMap();

    /**
     * 强制下线
     * @param key 用户ID
     * @return boolean
     * @author 二饭 [2022/9/28]
     **/
    @PostMapping("/verify/offline")
    public boolean offline(@RequestParam("key") String key);

    @PostMapping("/verify/exist")
    public boolean exist(@RequestParam("key") String key,@RequestParam("token") String token);

    @PostMapping("/verify/auth")
    public boolean auth(@RequestParam("key") String key, @RequestParam("token") String token, @RequestParam("url") String url);

    /**
     * 添加一个用户缓存资源
     * @param adminID 用户ID
     * @param resources 用户资源列表
     * @return boolean
     * @author 二饭 [2022/10/8]
     **/
    @PostMapping("/verify/cache")
    public boolean addAdminResources(@RequestParam("adminID") String adminID,@RequestParam("resources") String[] resources);

}