package cn.tworice.file.dao.po;

import cn.tworice.mybatis.po.BasicDO;
import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import lombok.EqualsAndHashCode;
import java.io.Serializable;

@ExcelIgnoreUnannotated
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("system_file")
public class SystemFileDO extends BasicDO implements Serializable {

    @TableId(type = IdType.AUTO)
    private Integer id;
    @ExcelProperty("文件路径")
    private String path;
    @ExcelProperty("文件名称")
    private String name;
    @ExcelProperty("文件类型")
    private Integer type;

    @ExcelProperty("所属父目录")
    private Integer parent;
    @ExcelProperty("文件大小")
    private Long size;
    @ExcelProperty("是否分享")
    @TableField(value = "share")
    private Integer share;
    /**
     * 文件的访问权限级别 对应角色编号
     **/
    @ExcelProperty("访问级别")
    private Integer level;
    @ExcelProperty("访问密码")
    private String pwd;
    @TableField(value = "state")
    private String state;
}