package cn.tworice.file.controller;


import cn.tworice.common.util.RequestUtil;
import cn.tworice.file.constand.FileType;
import cn.tworice.file.controller.vo.SystemFileVO;
import cn.tworice.file.service.SystemFileService;
import cn.tworice.log.annotation.Log;
import cn.tworice.common.util.excel.InductsListener;
import cn.tworice.common.vo.*;
import cn.tworice.file.dao.po.SystemFileDO;
import cn.tworice.mybatis.vo.PageParam;
import cn.tworice.upload.service.DownloadService;
import cn.tworice.upload.service.UploadUtil;
import com.alibaba.excel.EasyExcel;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.io.*;

import io.swagger.annotations.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

@RestController
@RequestMapping("/file/systemFile")
@CrossOrigin
@Log(table = "system_file")
@Api(tags = "文件管理")
public class SystemFileController {

    @Resource
    private SystemFileService service;

    @Resource
    private UploadUtil uploadUtil;

    @Resource
    private DownloadService downloadService;

    @GetMapping("list")
    @ApiOperation("获取分页列表")
    public RequestResult list(PageParam pageParam, @ApiParam("查询条件") SystemFileVO entity) {
        return RequestResult.success().setData(service.list(pageParam,entity));
    }

    @GetMapping("cancel")
    public RequestResult add(Integer id) {
        service.cancelShare(id);
        return RequestResult.success(StateCodeConst.MESSAGE,"取消分享成功");
    }

    @PostMapping("add")
    @ApiOperation("新增数据")
    public RequestResult add(SystemFileDO entity, MultipartFile file) {
        service.addFile(entity, file);
        service.set(entity);
        return RequestResult.success();
    }

    @DeleteMapping("del")
    @ApiOperation("删除数据")
    public RequestResult del(@ApiParam("数据ID数组") Integer[] ids) {
        service.del(ids);
        return RequestResult.success();
    }

    @PostMapping("inducts")
    @ApiOperation("Excel表格批量上传数据")
    public RequestResult inducts(@ApiParam("Excel文件") MultipartFile file) {
        try (InputStream inputStream = file.getInputStream()){
            EasyExcel.read(inputStream, SystemFileDO.class, new InductsListener(service)).sheet().doRead();
            return RequestResult.success("批量导入数据成功");
        } catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @GetMapping("info")
    @ApiOperation("获取数据")
    public RequestResult info(Integer id) {
        return RequestResult.success().appendData("info", service.info(id));
    }

    @GetMapping("downloadLocal/{id}")
    @ResponseBody
    public void downloadLocal(@PathVariable Integer id, HttpServletResponse response) throws Exception {
        SystemFileDO info = service.info(id);
        if(FileType.FOLDER.equals(info.getType())){
            RequestUtil.returnJson(response,RequestResult.error("文件夹不支持下载"));
            return;
        }
        // 文件属于分享状态 或 当前是创建人
        if (info.getShare() == 1) {
            String path = uploadUtil.getUploadPath()+ File.separator  + info.getPath();
            response.reset();
            response.setContentType("application/octet-stream");
            response.addHeader("Content-Disposition", "attachment; filename=\"" + info.getName() + "\"");
            downloadService.outputResponse(new File(path), response);
        }else{
            RequestUtil.returnJson(response,RequestResult.error("不具备访问权限"));
        }
    }

    @PostMapping("update")
    @ApiOperation("更新数据")
    public RequestResult add(SystemFileDO entity) {
        service.set(entity);
        return RequestResult.success();
    }
}