/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.file.controller;

import cn.tworice.common.util.RequestUtil;
import cn.tworice.common.util.excel.InductsListener;
import cn.tworice.common.util.excel.InductsListenerService;
import cn.tworice.common.vo.RequestResult;
import cn.tworice.common.vo.StateCodeConst;
import cn.tworice.file.constand.FileType;
import cn.tworice.file.controller.vo.SystemFileVO;
import cn.tworice.file.dao.po.SystemFileDO;
import cn.tworice.file.service.SystemFileService;
import cn.tworice.log.annotation.Log;
import cn.tworice.mybatis.vo.PageParam;
import cn.tworice.upload.service.DownloadService;
import cn.tworice.upload.service.UploadUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.ReadListener;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.InputStream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/file/systemFile"})
@CrossOrigin
@Log(table="system_file")
@Api(tags={"\u6587\u4ef6\u7ba1\u7406"})
public class SystemFileController {
    @Resource
    private SystemFileService service;
    @Resource
    private UploadUtil uploadUtil;
    @Resource
    private DownloadService downloadService;

    @GetMapping(value={"list"})
    @ApiOperation(value="\u83b7\u53d6\u5206\u9875\u5217\u8868")
    public RequestResult list(PageParam pageParam, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") SystemFileVO entity) {
        return RequestResult.success().setData(this.service.list(pageParam, entity));
    }

    @GetMapping(value={"cancel"})
    public RequestResult add(Integer id) {
        this.service.cancelShare(id);
        return RequestResult.success((Integer)StateCodeConst.MESSAGE, (String)"\u53d6\u6d88\u5206\u4eab\u6210\u529f");
    }

    @PostMapping(value={"add"})
    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    public RequestResult add(SystemFileDO entity, MultipartFile file) {
        this.service.addFile(entity, file);
        this.service.set(entity);
        return RequestResult.success();
    }

    @DeleteMapping(value={"del"})
    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    public RequestResult del(@ApiParam(value="\u6570\u636eID\u6570\u7ec4") Integer[] ids) {
        this.service.del(ids);
        return RequestResult.success();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(value={"inducts"})
    @ApiOperation(value="Excel\u8868\u683c\u6279\u91cf\u4e0a\u4f20\u6570\u636e")
    public RequestResult inducts(@ApiParam(value="Excel\u6587\u4ef6") MultipartFile file) {
        try (InputStream inputStream = file.getInputStream();){
            EasyExcel.read((InputStream)inputStream, SystemFileDO.class, (ReadListener)new InductsListener((InductsListenerService)this.service)).sheet().doRead();
            RequestResult requestResult = RequestResult.success((String)"\u6279\u91cf\u5bfc\u5165\u6570\u636e\u6210\u529f");
            return requestResult;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @GetMapping(value={"info"})
    @ApiOperation(value="\u83b7\u53d6\u6570\u636e")
    public RequestResult info(Integer id) {
        return RequestResult.success().appendData("info", (Object)this.service.info(id));
    }

    @GetMapping(value={"downloadLocal/{id}"})
    @ResponseBody
    public void downloadLocal(@PathVariable Integer id, HttpServletResponse response) throws Exception {
        SystemFileDO info = this.service.info(id);
        if (FileType.FOLDER.equals(info.getType())) {
            RequestUtil.returnJson((HttpServletResponse)response, (RequestResult)RequestResult.error((String)"\u6587\u4ef6\u5939\u4e0d\u652f\u6301\u4e0b\u8f7d"));
            return;
        }
        if (info.getShare() == 1) {
            String path = this.uploadUtil.getUploadPath() + File.separator + info.getPath();
            response.reset();
            response.setContentType("application/octet-stream");
            response.addHeader("Content-Disposition", "attachment; filename=\"" + info.getName() + "\"");
            this.downloadService.outputResponse(new File(path), response);
        } else {
            RequestUtil.returnJson((HttpServletResponse)response, (RequestResult)RequestResult.error((String)"\u4e0d\u5177\u5907\u8bbf\u95ee\u6743\u9650"));
        }
    }

    @PostMapping(value={"update"})
    @ApiOperation(value="\u66f4\u65b0\u6570\u636e")
    public RequestResult add(SystemFileDO entity) {
        this.service.set(entity);
        return RequestResult.success();
    }
}

