/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.file.service;

import cn.tworice.common.util.excel.InductsListenerService;
import cn.tworice.file.constand.ShareStateConst;
import cn.tworice.file.controller.vo.SystemFileVO;
import cn.tworice.file.dao.SystemFileDao;
import cn.tworice.file.dao.po.SystemFileDO;
import cn.tworice.mybatis.po.BasicDO;
import cn.tworice.mybatis.query.MPJLambdaWrapperX;
import cn.tworice.mybatis.vo.PageParam;
import cn.tworice.upload.service.UploadService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SystemFileService
implements InductsListenerService<SystemFileDO> {
    @Resource
    private SystemFileDao dao;
    @Resource
    private UploadService uploadService;

    public void addFile(SystemFileDO entity, MultipartFile file) {
        if (file == null || file.isEmpty()) {
            return;
        }
        entity.setSize(file.getSize());
        entity.setName(file.getOriginalFilename());
        entity.setPath(this.uploadService.uploadFile(file));
        if (entity.getParent() == null) {
            entity.setParent(1);
        }
        if (entity.getShare() == null) {
            entity.setShare(0);
        }
    }

    public Map<String, Object> list(PageParam pageParam, SystemFileVO entity) {
        return this.dao.selectPage(pageParam, (Wrapper)new MPJLambdaWrapperX().eqIfPresent(SystemFileDO::getId, (Object)entity.getId()).likeIfPresent(SystemFileDO::getName, entity.getName()).eqIfPresent(SystemFileDO::getParent, (Object)entity.getParent()).eqIfPresent(SystemFileDO::getType, (Object)entity.getType()).eqIfPresent(SystemFileDO::getPwd, (Object)entity.getPwd()).eqIfPresent(SystemFileDO::getState, (Object)entity.getState()).eqIfPresent(BasicDO::getCreator, (Object)entity.getCreator()).eqIfPresent(SystemFileDO::getShare, (Object)entity.getShare()).inIfPresent(SystemFileDO::getLevel, entity.getHaveLevel()).orderByDesc(BasicDO::getUpdateTime));
    }

    public int set(SystemFileDO entity) {
        if (entity.getId() == null) {
            return this.dao.insert(entity);
        }
        return this.dao.updateById(entity);
    }

    public boolean update(SystemFileDO entity) {
        return this.dao.updateById(entity) == 1;
    }

    public int del(Integer[] ids) {
        return this.dao.deleteBatchIds(Arrays.asList(ids));
    }

    public boolean saveBatch(List<SystemFileDO> list) {
        list.forEach(item -> item.setCreateTime(System.currentTimeMillis()));
        return this.dao.insertBatch(list, list.size());
    }

    public SystemFileDO info(int id) {
        return (SystemFileDO)this.dao.selectById(Integer.valueOf(id));
    }

    public void cancelShare(Integer id) {
        SystemFileDO info = this.info(id);
        info.setShare(ShareStateConst.unshare);
        this.set(info);
    }
}

