package cn.tworice.gateway.util;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

/**
 * 解决Gateway网关的过滤器中无法使用IOC容器中的Bean
 * @author 二饭 [2022/9/28]
 **/
public class AutowiredBean{

   private static ApplicationContext applicationContext;

   public static void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
      if (AutowiredBean.applicationContext == null) {
         AutowiredBean.applicationContext = applicationContext;
      }
   }

   public static ApplicationContext getApplicationContext() {
      return applicationContext;
   }

   public static Object getBean(String name) {
      return getApplicationContext().getBean(name);
   }

   public static <T> T getBean(Class<T> clazz) {
      return getApplicationContext().getBean(clazz);
   }

   public static <T> T getBean(String name, Class<T> clazz) {
      return getApplicationContext().getBean(name, clazz);
   }

}