package cn.tworice.gateway.auth;

import java.util.Map;

public interface OnlineService {

    /**
     * 使指定用户下线
     * @param key 用户ID
     * @return boolean 是否下线成功
     **/
    boolean offline(String key);

    /**
     * 获取当前在线的用户列表
     * @return java.util.Map<java.lang.String, java.lang.String>
     **/
    Map<String, String> onlineMap();

    /**
     * 判断用户是否在线
     * @param key 用户ID
     * @param token 用户Token
     * @return boolean
     **/
    boolean exist(String key,String token);

    /**
     * 用户上线
     * @param key 用户ID
     * @param token 用户Token
     * @return boolean
     **/
    boolean online(String key, String token);
}
