/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.generate.service.impl;

import cn.tworice.common.util.StringUtils;
import cn.tworice.generate.service.CodeGenerationService;
import cn.tworice.generate.util.CodeUtils;
import cn.tworice.generate.vo.CreateServerVO;
import cn.tworice.generate.vo.Parameter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DefaultCodeGenerationServiceImpl
implements CodeGenerationService {
    private static final Logger log = LoggerFactory.getLogger(DefaultCodeGenerationServiceImpl.class);
    @Resource
    private CodeUtils codeUtil;
    private final List<String> ignoreField = new ArrayList<String>();

    @PostConstruct
    public void initIgnoreField() {
        this.ignoreField.add("id");
        this.ignoreField.add("create_time");
        this.ignoreField.add("update_time");
        this.ignoreField.add("creator");
        this.ignoreField.add("deleted");
    }

    @Override
    public boolean createClient(CreateServerVO createServerVO) {
        try {
            String content = this.codeUtil.readByName("client");
            content = content.replace("-tworice_name-", createServerVO.getEntityName());
            StringBuilder clientHeader = new StringBuilder();
            clientHeader.append("@RestController\r\n");
            clientHeader.append("@RequestMapping(\"");
            clientHeader.append(createServerVO.getUrl());
            clientHeader.append("\")\r\n");
            clientHeader.append("@CrossOrigin\r\n");
            clientHeader.append("@Log(table = \"");
            clientHeader.append(createServerVO.getTableName());
            clientHeader.append("\")\r\n");
            clientHeader.append("@Api(tags = \"");
            clientHeader.append(createServerVO.getTableComment());
            clientHeader.append("\")\r\n");
            content = content.replace("-tworice_client_header-", clientHeader.toString());
            this.codeUtil.createFile(this.codeUtil.getAdminProjectPath() + "\\src\\main\\java\\cn\\tworice\\client\\web\\" + createServerVO.getEntityName() + "Client.java", content);
            log.info("\u751f\u6210Client\u6587\u4ef6\u6210\u529f");
        }
        catch (Exception exception) {
            log.error("\u751f\u6210Client\u6587\u4ef6\u5931\u8d25", (Throwable)exception);
            return false;
        }
        return true;
    }

    @Override
    public boolean createService(CreateServerVO createServerVO) {
        try {
            StringBuilder builder = new StringBuilder();
            String templateContent = this.codeUtil.readByName("service");
            templateContent = templateContent.replace("-tworice_name-", createServerVO.getEntityName());
            templateContent = templateContent.replace("-tworice_query-", this.buildQuery(createServerVO));
            int serviceEndIndex = templateContent.indexOf("@Service") + 8;
            builder.append(templateContent, 0, serviceEndIndex);
            builder.append("\r\n");
            int data1 = templateContent.indexOf("@Resource") + 9;
            builder.append(templateContent, serviceEndIndex, data1);
            builder.append("\r\n");
            builder.append(templateContent.substring(data1).trim());
            this.codeUtil.createFile(this.codeUtil.getAdminProjectPath() + "\\src\\main\\java\\cn\\tworice\\client\\service\\" + createServerVO.getEntityName() + "Service.java", builder.toString());
            log.info("\u751f\u6210Service\u6587\u4ef6\u6210\u529f");
        }
        catch (Exception exception) {
            log.error(exception.getMessage());
            log.error("\u751f\u6210Service\u6587\u4ef6\u5931\u8d25");
            return false;
        }
        return true;
    }

    @Override
    public boolean createDao(CreateServerVO createServerVO) {
        try {
            StringBuilder builder = new StringBuilder();
            String content = this.codeUtil.readByName("dao");
            content = content.replace("-tworice_name-", createServerVO.getEntityName());
            int data = content.indexOf("@Repository") + 11;
            builder.append(content, 0, data);
            builder.append("\r\n");
            builder.append(content.substring(data).trim());
            this.codeUtil.createFile(this.codeUtil.getAdminProjectPath() + "\\src\\main\\java\\cn\\tworice\\client\\dao\\" + createServerVO.getEntityName() + "Dao.java", builder.toString());
            log.info("\u751f\u6210Dao\u6587\u4ef6\u6210\u529f");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            log.error("\u751f\u6210Dao\u6587\u4ef6\u5931\u8d25");
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public boolean createMapper(CreateServerVO createServerVO) {
        try {
            int i;
            String content = this.codeUtil.readByName("mapper");
            content = content.replace("-tworice_name-", createServerVO.getEntityName());
            StringBuilder queryListWhere = new StringBuilder();
            StringBuilder queryList = new StringBuilder();
            StringBuilder queryTotal = new StringBuilder();
            StringBuilder queryListJoinTable = new StringBuilder("");
            StringBuilder insertSql = new StringBuilder();
            insertSql.append("INSERT INTO ");
            insertSql.append(createServerVO.getTableName());
            insertSql.append("(");
            StringBuilder insertList = new StringBuilder();
            insertList.append("INSERT INTO ");
            insertList.append(createServerVO.getTableName());
            insertList.append("(");
            StringBuilder updateSql = new StringBuilder();
            updateSql.append("UPDATE ");
            updateSql.append(createServerVO.getTableName());
            updateSql.append("<trim prefix=\"SET\" prefixOverrides=\",\">");
            List<Parameter> fieldList = createServerVO.getFieldList();
            for (i = 0; i < fieldList.size(); ++i) {
                String field = fieldList.get(i).getField();
                String fieldHump = StringUtils.lineToHump((String)field);
                insertSql.append(field);
                insertList.append(field);
                if (!"create_time".equals(field)) {
                    updateSql.append("<if test=\"");
                    updateSql.append(fieldHump);
                    updateSql.append("!=null\">,");
                    updateSql.append(field);
                    updateSql.append("=");
                    updateSql.append("#{");
                    updateSql.append(fieldHump);
                    updateSql.append("}");
                    updateSql.append("</if>");
                }
                if (fieldList.get(i).getQuery().booleanValue()) {
                    queryListWhere.append("<if test=\"entity.").append(fieldHump).append("!=null\"> ");
                    queryTotal.append("<if test=\"").append(fieldHump).append("!=null\"> ");
                    if ("=".equals(fieldList.get(i).getQueryType()) || "\u5b57\u5178".equals(fieldList.get(i).getQueryType())) {
                        queryListWhere.append("AND a.").append(field).append(" = #{entity.").append(fieldHump).append("}");
                        queryTotal.append("AND a.").append(field).append(" = #{").append(fieldHump).append("}");
                    } else if ("LIKE".equals(fieldList.get(i).getQueryType())) {
                        queryListWhere.append("AND a.").append(field).append(" LIKE '%${entity.").append(fieldHump).append("}%'");
                        queryTotal.append("AND a.").append(field).append(" LIKE '%${").append(fieldHump).append("}%'");
                    } else if ("\u6570\u636e\u8868".equals(fieldList.get(i).getQueryType())) {
                        queryListWhere.append("AND a.").append(field).append(" = #{entity.").append(fieldHump).append("}");
                        queryTotal.append("AND a.").append(field).append(" = #{").append(fieldHump).append("}");
                    }
                    queryListWhere.append("</if>");
                    queryTotal.append("</if>");
                }
                if (i == fieldList.size() - 1) {
                    updateSql.append("</trim>");
                    continue;
                }
                insertSql.append(",");
                insertList.append(",");
            }
            insertSql.append(") VALUE(");
            insertList.append(") VALUES");
            insertList.append("<foreach collection=\"list\" separator=\",\" item=\"item\">(");
            for (i = 0; i < fieldList.size(); ++i) {
                insertSql.append("#{");
                insertList.append("#{item.");
                insertSql.append(StringUtils.lineToHump((String)fieldList.get(i).getField()));
                insertList.append(StringUtils.lineToHump((String)fieldList.get(i).getField()));
                if (i == fieldList.size() - 1) {
                    insertSql.append("}");
                    insertList.append("}");
                    continue;
                }
                insertSql.append("},");
                insertList.append("},");
            }
            insertSql.append(")");
            insertList.append(")</foreach>");
            content = content.replace("-tworice_insert_sql-", insertSql.toString());
            content = content.replace("-tworice_insert_list_sql-", insertList.toString());
            updateSql.append("\r\n WHERE id=#{id}");
            content = content.replace("-tworice_update_sql-", updateSql.toString());
            content = content.replace("-tworice_table_name-", createServerVO.getTableName());
            content = content.replace("-tworice_query_list_where-", queryListWhere.toString());
            content = content.replace("-tworice_query_total-", queryTotal.toString());
            content = content.replace("-tworice_join_table-", queryListJoinTable.toString());
            this.codeUtil.createFile(System.getProperty("user.dir") + "\\src\\main\\resources\\cn\\tworice\\client\\dao\\" + createServerVO.getEntityName() + "Dao.xml", content);
            log.info("\u751f\u6210Mapper\u6587\u4ef6\u6210\u529f");
        }
        catch (Exception exception) {
            log.error("\u751f\u6210Mapper\u6587\u4ef6\u5931\u8d25", (Throwable)exception);
            return false;
        }
        return true;
    }

    @Override
    public boolean createEntity(CreateServerVO createServerVO) {
        try {
            StringBuilder builder = new StringBuilder();
            String content = this.codeUtil.readByName("entity");
            content = content.replace("-tworice_name-", createServerVO.getEntityName());
            content = content.replace("-tworice_table_name-", createServerVO.getTableName());
            int data = content.indexOf("@Data") + 5;
            builder.append(content, 0, data);
            builder.append("\r\n");
            int end = content.lastIndexOf("}");
            builder.append(content.substring(data, end).trim());
            builder.append("\r\n");
            List<Parameter> fieldList = createServerVO.getFieldList();
            fieldList.forEach(item -> {
                if (!this.ignoreField.contains(item.getField())) {
                    builder.append("@ExcelProperty(\"");
                    builder.append(item.getName());
                    builder.append("\")\r\n");
                    builder.append("private ");
                    builder.append(item.getType()).append(" ");
                    builder.append(StringUtils.lineToHump((String)item.getField())).append(" ");
                    builder.append(";\r\n");
                }
            });
            builder.append("}");
            this.codeUtil.createFile(this.codeUtil.getAdminProjectPath() + "\\src\\main\\java\\cn\\tworice\\common\\entity\\code\\" + createServerVO.getEntityName() + ".java", builder.toString());
            log.info("\u751f\u6210\u5b9e\u4f53\u7c7b\u6587\u4ef6\u6210\u529f");
        }
        catch (Exception exception) {
            log.error("\u751f\u6210\u5b9e\u4f53\u7c7b\u6587\u4ef6\u5931\u8d25", (Throwable)exception);
            return false;
        }
        return true;
    }

    private String buildQuery(CreateServerVO createServerVO) {
        StringBuilder result = new StringBuilder();
        List<Parameter> fieldList = createServerVO.getFieldList();
        for (Parameter item : fieldList) {
            String field = item.getField();
            String fieldHump = StringUtils.lineToHump2((String)field);
            if ("create_time".equals(field) || "update_time".equals(field) || "creator".equals(field) || !item.getQuery().booleanValue()) continue;
            result.append(".").append(this.getQueryType(item.getQueryType())).append("(").append(createServerVO.getEntityName()).append("::get").append(fieldHump).append(",entity.get").append(fieldHump).append("())");
        }
        return result.toString();
    }

    private String getQueryType(String queryType) {
        switch (queryType) {
            case "=": 
            case "\u5b57\u5178": 
            case "\u6570\u636e\u8868": {
                return "eqIfPresent";
            }
            case "LIKE": {
                return "likeIfPresent";
            }
            case "<": {
                return "ltIfPresent";
            }
            case "<=": {
                return "leIfPresent";
            }
            case ">": {
                return "gtIfPresent";
            }
            case ">=": {
                return "geIfPresent";
            }
            case "\u4e0d\u7b49\u4e8e": {
                return "neIfPresent";
            }
        }
        log.error("\u5f53\u524d\u7248\u672c\u76ee\u524d\u4e0d\u652f\u6301\u67e5\u8be2\u7c7b\u578b\uff1a" + queryType);
        return "";
    }
}

