/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.generate.util;

import cn.tworice.generate.config.GenerateProperties;
import cn.tworice.generate.exception.GenerateException;
import cn.tworice.generate.vo.Parameter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CodeUtils {
    private static final Logger log = LoggerFactory.getLogger(CodeUtils.class);
    @Resource
    private GenerateProperties generateProperties;

    public String getAdminProjectPath() {
        return this.getPath() + File.separator + this.generateProperties.getAdminProject();
    }

    public String getVueProjectPath() {
        return this.getPath() + File.separator + this.generateProperties.getVueProject();
    }

    public void updateType(List<Parameter> list) {
        list.forEach(item -> {
            String type = item.getType();
            if (type.equals("int")) {
                item.setType("Integer");
            } else if (type.equals("bigint")) {
                item.setType("Long");
            } else if (type.contains("varchar") || type.equals("text")) {
                item.setType("String");
            } else if (type.equals("decimal")) {
                item.setType("Double");
            } else if (type.equals("longtext")) {
                item.setType("String");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readByName(String templateName) {
        log.debug("\u8bfb\u53d6\u6a21\u677f\u5185\u5bb9\uff1a" + templateName);
        StringBuilder sbf = new StringBuilder();
        try {
            InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream(this.generateProperties.getTemplate() + "/" + templateName);
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(resourceAsStream));
                try {
                    String tempStr;
                    while ((tempStr = reader.readLine()) != null) {
                        sbf.append(tempStr).append("\n");
                    }
                }
                finally {
                    if (Collections.singletonList(reader).get(0) != null) {
                        reader.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(resourceAsStream).get(0) != null) {
                    resourceAsStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sbf.toString();
    }

    public boolean createFile(String fileName, String content) {
        File file = new File(fileName);
        try {
            File fileParent = file.getParentFile();
            if (!fileParent.mkdirs()) {
                fileParent.mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            } else {
                file.delete();
                file.createNewFile();
            }
            FileWriter fw = new FileWriter(file);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(content);
            bw.flush();
            bw.close();
            fw.close();
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u6587\u4ef6\u5931\u8d25" + e.getClass().toString());
            return false;
        }
        log.info("\u751f\u6210\u6587\u4ef6\u6210\u529f");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readByPath(String filePath) {
        File file = new File(filePath);
        BufferedReader reader = null;
        StringBuilder sbf = new StringBuilder();
        try {
            String tempStr;
            reader = new BufferedReader(new FileReader(file));
            while ((tempStr = reader.readLine()) != null) {
                sbf.append(tempStr);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        return sbf.toString();
    }

    private String getPath() {
        String userDir = System.getProperty("user.dir");
        if (new File(userDir + File.separator + "src").exists()) {
            int lastIndexOf = userDir.lastIndexOf("\\");
            if (lastIndexOf != -1) {
                return userDir.substring(0, lastIndexOf + 1);
            }
            throw new GenerateException("\u83b7\u53d6\u9879\u76ee\u8def\u5f84\u5931\u8d25");
        }
        return userDir;
    }
}

