package cn.tworice.generate.constant;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.ArrayList;
import java.util.List;

@AllArgsConstructor
@Getter
public enum DataTypeConst {

    INT("int", "Integer"),
    BIGINT("bigint", "Long"),
    DECIMAL("decimal", "Double"),
    BOOLEAN("tinyint", "Boolean"),
    VARCHAR64("varchar(64)", "String"),
    VARCHAR256("varchar(256)", "String"),
    TEXT("text", "String"),
    LONGTEXT("longtext", "String");

    private final String dbType;

    private final String javaType;

    /**
     * 通过枚举类中的dbType获取javaType
     */
    public static String getJavaType(String dbType) {
        for (DataTypeConst dataType : DataTypeConst.values()) {
            if (dataType.dbType.equals(dbType)) {
                return dataType.javaType;
            }
        }
        return null;
    }

    /**
     * 获取所有的dbType列表
     */
    public static List<String> getDbTypes() {
        DataTypeConst[] values = DataTypeConst.values();
        List<String> dbTypeList = new ArrayList<>();
        for (DataTypeConst value : values) {
            dbTypeList.add(value.dbType);
        }
        return dbTypeList;
    }
}
