package cn.tworice.generate.util;

import cn.tworice.generate.config.GenerateProperties;
import cn.tworice.generate.constant.DataTypeConst;
import cn.tworice.generate.exception.GenerateException;
import cn.tworice.generate.vo.Parameter;
import lombok.Cleanup;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.io.*;
import java.util.List;

@Component
@Slf4j
public class CodeUtils {

    @Resource
    private GenerateProperties generateProperties;

    /**
     * 获取后台服务项目路径
     *
     * @return
     */
    public String getAdminProjectPath() {
        return getPath() + File.separator + generateProperties.getAdminProject();
    }

    /**
     * 获取后端项目路径
     *
     * @return
     */
    public String getVueProjectPath() {
        return getPath() + File.separator + generateProperties.getVueProject();
    }




    /**
     * 将参数类型从SQL转为Java类型
     *
     * @author 二饭[tworice@sina.cn][2022/1/17 11:45]
     */
    public void updateType(List<Parameter> list) {
        list.forEach(item -> {
            String type = item.getType();
            item.setType(DataTypeConst.getJavaType(type));
        });
    }

    /**
     * 通过模板名称读取该模板内容
     *
     * @return 返回模板内容
     * @author 二饭[tworice@sina.cn][2022/1/11 13:08]
     */
    public String readByName(String templateName) {
        log.debug("读取模板内容：" + templateName);
        StringBuilder sbf = new StringBuilder();
        try {
            @Cleanup InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream(generateProperties.getTemplate() + "/" + templateName);
            @Cleanup BufferedReader reader = new BufferedReader(new InputStreamReader(resourceAsStream));
            String tempStr;
            while ((tempStr = reader.readLine()) != null) {
                sbf.append(tempStr).append("\n");
            }

        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sbf.toString();
    }


    /**
     * @param fileName 路径+文件名称
     * @param content  要写入文件的内容
     *                 创新新的文件，并写入内容
     *                 如果该文件存在则删除重新创建
     * @author 二饭[tworice@sina.cn][2022/1/12 0:18]
     */
    public boolean createFile(String fileName, String content) {
        File file = new File(fileName);
        try {
            File fileParent = file.getParentFile();
            if (!fileParent.mkdirs()) {
                fileParent.mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            } else {
                file.delete();
                file.createNewFile();
            }
            FileWriter fw = new FileWriter(file);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(content);
            bw.flush();
            bw.close();
            fw.close();
        } catch (Exception e) {
            log.error("生成文件失败" + e.getClass().toString());
            return false;
        }
        log.info("生成文件成功");
        return true;
    }

    /**
     * 读取指定文件内容并返回
     *
     * @author 二饭[tworice@sina.cn][2022/1/12 0:20]
     */
    public String readByPath(String filePath) {
        File file = new File(filePath);
        BufferedReader reader = null;
        StringBuilder sbf = new StringBuilder();
        try {
            reader = new BufferedReader(new FileReader(file));
            String tempStr;
            while ((tempStr = reader.readLine()) != null) {
                sbf.append(tempStr);
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                reader.close();
            } catch (IOException e1) {
                e1.printStackTrace();
            }

        }
        return sbf.toString();
    }


    /**
     * 获取项目路径
     * 判断是否存在src目录的原因如下：
     * 单元测试时获取的路径为当前后端项目
     * 服务启动时获取到的IDEA打开的项目路径
     * @return 包含前端和后端的外层目录
     */
    private String getPath() {
        String userDir = System.getProperty("user.dir");
        // 判断当前文件夹下有没有src文件夹
        if (new File(userDir + File.separator + "src").exists()) {
            int lastIndexOf = userDir.lastIndexOf("\\");
            if (lastIndexOf != -1) {
                return  userDir.substring(0, lastIndexOf + 1);
            } else {
                throw new GenerateException("获取项目路径失败");
            }
        } else {
            return userDir;
        }


    }
}
