/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.generate.constant;

import java.util.ArrayList;
import java.util.List;

public enum DataTypeConst {
    INT("int", "Integer"),
    BIGINT("bigint", "Long"),
    DECIMAL("decimal", "Double"),
    BOOLEAN("tinyint", "Boolean"),
    VARCHAR64("varchar(64)", "String"),
    VARCHAR256("varchar(256)", "String"),
    TEXT("text", "String"),
    LONGTEXT("longtext", "String");

    private final String dbType;
    private final String javaType;

    public static String getJavaType(String dbType) {
        for (DataTypeConst dataType : DataTypeConst.values()) {
            if (!dataType.dbType.equals(dbType)) continue;
            return dataType.javaType;
        }
        return null;
    }

    public static List<String> getDbTypes() {
        DataTypeConst[] values = DataTypeConst.values();
        ArrayList<String> dbTypeList = new ArrayList<String>();
        for (DataTypeConst value : values) {
            dbTypeList.add(value.dbType);
        }
        return dbTypeList;
    }

    private DataTypeConst(String dbType, String javaType) {
        this.dbType = dbType;
        this.javaType = javaType;
    }

    public String getDbType() {
        return this.dbType;
    }

    public String getJavaType() {
        return this.javaType;
    }
}

