/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.generate.service;

import cn.tworice.common.util.file.FileUtils;
import cn.tworice.generate.config.GenerateProperties;
import cn.tworice.generate.util.CodeUtils;
import cn.tworice.generate.vo.CodeVO;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class VueGeneration {
    private static final Logger log = LoggerFactory.getLogger(VueGeneration.class);
    @Resource
    private CodeUtils codeUtils;
    @Resource
    private GenerateProperties generateProperties;

    public boolean buildCodeVue(CodeVO codeVO) {
        String content = this.codeUtils.readByName(codeVO.getTemplateName());
        content = content.replace("-tworice_table_item-", codeVO.getTableItem());
        content = content.replace("-tworice_form_item-", codeVO.getFormItem());
        content = content.replace("-tworice_form-", codeVO.getForm());
        content = content.replace("-tworice_url-", codeVO.getUrl());
        content = content.replace("-tworice_rules-", codeVO.getRules());
        content = content.replace("-tworice_search_item-", codeVO.getSearchItem());
        content = content.replace("-tworice_search-", codeVO.getSearch());
        content = content.replace("-tworice_dict-", codeVO.getDict());
        content = content.replace("-tworice_init_dict-", codeVO.getInitDict());
        content = content.replace("-tworice_init_dicts-", codeVO.getInitDicts());
        content = content.replace("-tworice_show_info-", codeVO.getShowInfo());
        String fileName = this.codeUtils.getVueProjectPath() + "\\src\\components\\code\\" + codeVO.getPageName() + ".vue";
        return this.codeUtils.createFile(fileName, content);
    }

    public String getRouter() {
        String content = FileUtils.readFile((String)this.getRouterPath());
        content = content.substring(content.indexOf("//$start") + 8, content.lastIndexOf("//$end")).trim();
        return content;
    }

    public boolean addRouter(int type, String path, String name) {
        log.info("\u6dfb\u52a0\u8def\u7531\u4fe1\u606f");
        String router = null;
        if (type == 1) {
            router = this.addModuleToRouter(path, name);
        } else if (type == 2) {
            router = this.addPageToRouter(path, name);
        } else {
            return false;
        }
        return this.refreshRouter(router);
    }

    public boolean refreshRouter(String router) {
        log.info("\u5c06\u8def\u7531\u5185\u5bb9\u5199\u5165\u8def\u7531\u8868\u4e2d");
        try {
            if (router != null) {
                String file = this.getRouterPath();
                String fileContent = FileUtils.readFile((String)file);
                String content = fileContent.substring(0, fileContent.indexOf("//$start")) + "\r\n//$start\r\n" + router + "\r\n//$end\r\n";
                content = content + fileContent.substring(fileContent.indexOf("//$end") + 6);
                this.codeUtils.createFile(file, content);
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public String addModuleToRouter(String path, String name) {
        log.info("\u6dfb\u52a0\u6a21\u5757\u8def\u7531");
        String router = this.getRouter();
        String content = router.substring(0, router.lastIndexOf("]"));
        String buffer = "{path:'" + path + "',\nname:'" + name + "',\ncomponent: ()=>import('@/components/index'),\nchildren:[]},\n";
        content = content + buffer + "]";
        return content;
    }

    public String addPageToRouter(String path, String name) {
        String[] split;
        log.info("\u6dfb\u52a0\u9875\u9762\u8def\u7531");
        String router = this.getRouter();
        StringBuilder buffer = new StringBuilder();
        if (path == null || path.trim().isEmpty()) {
            return "";
        }
        String pathLevel = "";
        if ("/".equals(path.trim().charAt(0) + "")) {
            pathLevel = path.substring(1);
        }
        if ((split = pathLevel.split("/")).length == 1) {
            path = "/admin" + path;
        }
        String module = path.substring(0, path.lastIndexOf("/"));
        int moduleIndex = router.indexOf("\"" + module + "\"");
        buffer.append(router, 0, moduleIndex);
        String moduleContent = router.substring(moduleIndex);
        int childrenIndex = moduleContent.indexOf("children");
        buffer.append(moduleContent, 0, childrenIndex);
        buffer.append("children:");
        String childrenContent = moduleContent.substring(childrenIndex);
        String[] children = this.getBracketIndex('[', ']', childrenContent);
        if (children[0].length() == 2) {
            buffer.append(children[0], 0, children[0].length() - 1);
        } else {
            String substring = children[0].substring(0, children[0].length() - 2).trim();
            buffer.append(substring);
            if (!substring.endsWith(",") && !substring.endsWith("[")) {
                buffer.append(",");
            }
        }
        buffer.append("\n{path:'");
        buffer.append(path.substring(path.lastIndexOf("/") + 1));
        buffer.append("',");
        buffer.append("name:'");
        buffer.append(name);
        buffer.append("',");
        buffer.append("component: (resolve) =>require(['@/components/code/");
        buffer.append(path.substring(path.lastIndexOf("/") + 1));
        buffer.append(".vue',], resolve)},");
        buffer.append("]");
        buffer.append(children[1]);
        return buffer.toString();
    }

    public String[] getBracketIndex(char beginBracket, char endBracket, String content) {
        int number = 1;
        int beginIndex = content.indexOf(beginBracket);
        int endIndex = -1;
        for (int i = beginIndex + 1; i < content.length(); ++i) {
            if (content.charAt(i) == beginBracket) {
                ++number;
                continue;
            }
            if (content.charAt(i) != endBracket) continue;
            if (number - 1 == 0) {
                endIndex = i;
                break;
            }
            --number;
        }
        String[] arr = new String[]{content.substring(beginIndex, endIndex + 1).trim(), content.substring(endIndex + 1).trim()};
        return arr;
    }

    private String getRouterPath() {
        return this.codeUtils.getVueProjectPath() + "\\src\\core\\router.js";
    }
}

