/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.generate.web;

import cn.tworice.common.util.StringUtils;
import cn.tworice.common.vo.RequestResult;
import cn.tworice.common.vo.StateCodeConst;
import cn.tworice.generate.constant.DataTypeConst;
import cn.tworice.generate.dao.CodeGenerationDao;
import cn.tworice.generate.exception.GenerateException;
import cn.tworice.generate.po.DataBaseTable;
import cn.tworice.generate.service.CodeGenerationService;
import cn.tworice.generate.service.VueGeneration;
import cn.tworice.generate.util.CodeUtils;
import cn.tworice.generate.vo.CodeVO;
import cn.tworice.generate.vo.CreateServerVO;
import cn.tworice.generate.vo.Parameter;
import cn.tworice.log.annotation.Log;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"admin/codeGeneration"})
@CrossOrigin
@Api(tags={"\u4ee3\u7801\u751f\u6210"})
@Log(ignore=true)
public class CodeGeneration {
    private static final Logger log = LoggerFactory.getLogger(CodeGeneration.class);
    @Resource
    private VueGeneration vueGeneration;
    @Resource
    private CodeGenerationService codeGenerationService;
    @Resource
    private CodeUtils codeUtil;
    @Resource
    private CodeGenerationDao dao;

    @GetMapping(value={"tables"})
    @ApiOperation(value="\u83b7\u53d6\u975e\u7cfb\u7edf\u8868")
    public RequestResult showTables() {
        RequestResult result = new RequestResult();
        List<DataBaseTable> dataBaseTables = this.dao.selectTableList();
        for (int i = 0; i < dataBaseTables.size(); ++i) {
            DataBaseTable dataBaseTable = dataBaseTables.get(i);
            if (dataBaseTable.getTableName().startsWith("system")) {
                dataBaseTables.remove(i);
                --i;
                continue;
            }
            dataBaseTable.setName(dataBaseTable.getTableComment());
            dataBaseTable.setId(dataBaseTable.getTableName());
        }
        result.appendData("list", dataBaseTables);
        return result;
    }

    @GetMapping(value={"read"})
    @ApiOperation(value="\u83b7\u53d6\u6a21\u677f\u5185\u5bb9")
    public RequestResult readFile(String templateName) {
        RequestResult result = new RequestResult();
        String content = this.codeUtil.readByName(templateName);
        result.appendData("content", (Object)content);
        return result;
    }

    @PostMapping(value={"writeVue"})
    @ApiOperation(value="\u751f\u6210Vue\u4ee3\u7801")
    public RequestResult write(CodeVO codeVO) {
        if (this.vueGeneration.buildCodeVue(codeVO)) {
            return RequestResult.success((Integer)StateCodeConst.MESSAGE, (String)"\u6784\u5efaVue\u9875\u9762\u6210\u529f");
        }
        return RequestResult.error((String)"\u6784\u5efaVue\u9875\u9762\u5931\u8d25");
    }

    @PostMapping(value={"writeServe"})
    @ApiOperation(value="\u751f\u6210\u670d\u52a1\u7aef\u53caSQL\u4ee3\u7801")
    public RequestResult write(CreateServerVO createServerVO) {
        List list = JSON.parseArray((String)createServerVO.getParameters(), Parameter.class);
        for (int i = 0; i < list.size(); ++i) {
            Parameter parameter = (Parameter)list.get(i);
            if (parameter.getField().equals("id")) {
                list.remove(i);
                --i;
                continue;
            }
            if (!parameter.getQuery().booleanValue() || !parameter.getQueryType().equals("\u6570\u636e\u8868")) continue;
            String string = parameter.getDict();
        }
        try {
            this.dao.createNewTable(list, createServerVO.getTableName(), createServerVO.getTableComment());
            log.info("\u521b\u5efa\u6570\u636e\u8868\u6210\u529f");
        }
        catch (Exception exception) {
            throw new GenerateException("\u6570\u636e\u8868\u521b\u5efa\u5931\u8d25");
        }
        this.codeUtil.updateType(list);
        createServerVO.setFieldList(list);
        createServerVO.setEntityName(StringUtils.lineToHump2((String)createServerVO.getTableName()));
        boolean success = this.codeGenerationService.createEntity(createServerVO);
        success &= this.codeGenerationService.createDao(createServerVO);
        success &= this.codeGenerationService.createService(createServerVO);
        if (success &= this.codeGenerationService.createClient(createServerVO)) {
            return RequestResult.success((Integer)StateCodeConst.MESSAGE, (String)"\u751f\u6210\u670d\u52a1\u7aef\u6587\u4ef6\u6210\u529f");
        }
        return RequestResult.error((String)"\u751f\u6210\u670d\u52a1\u7aef\u6587\u4ef6\u5931\u8d25");
    }

    @GetMapping(value={"router"})
    @ApiOperation(value="\u83b7\u53d6\u8def\u7531\u6587\u4ef6")
    public RequestResult getRouter() {
        return RequestResult.success().appendData("router", (Object)this.vueGeneration.getRouter());
    }

    @GetMapping(value={"dbTypes"})
    @ApiOperation(value="\u83b7\u53d6\u652f\u6301\u7684\u6570\u636e\u5e93\u5b57\u6bb5\u7c7b\u578b")
    public RequestResult dbTypes() {
        return RequestResult.success().appendData("dbTypes", DataTypeConst.getDbTypes());
    }
}

