package cn.tworice.ip.util;

import java.net.InetAddress;
import java.net.UnknownHostException;

/**
 * DNS相关工具
 * @author 二饭 [2023/3/7]
 **/
public class DNSUtil {
    /**
     * 通过域名获取IP
     * @param domain 需要解析的域名
     * @return java.lang.String
     * @author 二饭 [2023/3/7]
     **/
    public static InetAddress[] getIPByDomain(String domain) {
        try {
            return InetAddress.getAllByName(domain);
        } catch (UnknownHostException e) {
            System.out.println("无法解析域名：" + domain);
            e.printStackTrace();
            return null;
        }
    }
}
