package cn.tworice.log.dao.po;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;

/**
 * 管理员操作日志
 * @author 二饭
 */
@Data
@ExcelIgnoreUnannotated
@TableName("system_operation_log")
public class OperationLogDO implements Serializable {
    private static final long serialVersionUID = 187694670444559721L;
    @TableId(type = IdType.ASSIGN_UUID)
    private String id;
    @ExcelProperty("操作时间")
    private Long createTime;
    @ExcelProperty("操作内容")
    private String active;

    @ExcelProperty("操作人")
    private String userId;

    private String tableName;

    private String targetId;

    @ExcelProperty("操作IP")
    private String ipAddr;

    public OperationLogDO(String id, Long time, String active, String userId) {
        this.id = id;
        this.createTime = time;
        this.userId = userId;
        this.active = active;
    }

    public OperationLogDO() {
    }
}